/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.base;

import me.lib720.caprica.vlcj.binding.internal.libvlc_instance_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_media_player_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_renderer_item_t;
import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import me.lib720.caprica.vlcj.player.base.AudioApi;
import me.lib720.caprica.vlcj.player.base.ChapterApi;
import me.lib720.caprica.vlcj.player.base.ControlsApi;
import me.lib720.caprica.vlcj.player.base.EventApi;
import me.lib720.caprica.vlcj.player.base.LogoApi;
import me.lib720.caprica.vlcj.player.base.MarqueeApi;
import me.lib720.caprica.vlcj.player.base.MediaApi;
import me.lib720.caprica.vlcj.player.base.MenuApi;
import me.lib720.caprica.vlcj.player.base.RoleApi;
import me.lib720.caprica.vlcj.player.base.SnapshotApi;
import me.lib720.caprica.vlcj.player.base.StatusApi;
import me.lib720.caprica.vlcj.player.base.SubitemApi;
import me.lib720.caprica.vlcj.player.base.SubpictureApi;
import me.lib720.caprica.vlcj.player.base.TeletextApi;
import me.lib720.caprica.vlcj.player.base.TitleApi;
import me.lib720.caprica.vlcj.player.base.VideoApi;
import me.lib720.caprica.vlcj.player.renderer.RendererItem;
import me.lib720.caprica.vlcj.support.eventmanager.TaskExecutor;

public class MediaPlayer {
    protected final libvlc_instance_t libvlcInstance;
    private final libvlc_media_player_t mediaPlayerInstance;
    private final TaskExecutor executor = new TaskExecutor();
    private RendererItem renderer;
    private Object userData;
    private final AudioApi audioApi;
    private final ChapterApi chapterApi;
    private final ControlsApi controlsApi;
    private final EventApi eventApi;
    private final LogoApi logoApi;
    private final MarqueeApi marqueeApi;
    private final MediaApi mediaApi;
    private final MenuApi menuApi;
    private final RoleApi roleApi;
    private final SnapshotApi snapshotApi;
    private final StatusApi statusApi;
    private final SubitemApi subitemApi;
    private final SubpictureApi subpictureApi;
    private final TeletextApi teletextApi;
    private final TitleApi titleApi;
    private final VideoApi videoApi;

    public MediaPlayer(libvlc_instance_t instance) {
        this(instance, MediaPlayer.newNativeMediaPlayer(instance));
    }

    public MediaPlayer(libvlc_instance_t instance, libvlc_media_player_t mediaPlayerInstance) {
        this.libvlcInstance = instance;
        this.mediaPlayerInstance = mediaPlayerInstance;
        this.audioApi = new AudioApi(this);
        this.chapterApi = new ChapterApi(this);
        this.controlsApi = new ControlsApi(this);
        this.eventApi = new EventApi(this);
        this.logoApi = new LogoApi(this);
        this.marqueeApi = new MarqueeApi(this);
        this.mediaApi = new MediaApi(this);
        this.menuApi = new MenuApi(this);
        this.roleApi = new RoleApi(this);
        this.snapshotApi = new SnapshotApi(this);
        this.statusApi = new StatusApi(this);
        this.subitemApi = new SubitemApi(this);
        this.subpictureApi = new SubpictureApi(this);
        this.teletextApi = new TeletextApi(this);
        this.titleApi = new TitleApi(this);
        this.videoApi = new VideoApi(this);
    }

    private static libvlc_media_player_t newNativeMediaPlayer(libvlc_instance_t instance) {
        libvlc_media_player_t result = LibVlc.libvlc_media_player_new(instance);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Failed to get a new native media player instance");
    }

    public final AudioApi audio() {
        return this.audioApi;
    }

    public final ChapterApi chapters() {
        return this.chapterApi;
    }

    public final ControlsApi controls() {
        return this.controlsApi;
    }

    public final EventApi events() {
        return this.eventApi;
    }

    public final LogoApi logo() {
        return this.logoApi;
    }

    public final MarqueeApi marquee() {
        return this.marqueeApi;
    }

    public final MediaApi media() {
        return this.mediaApi;
    }

    public final MenuApi menu() {
        return this.menuApi;
    }

    public final RoleApi role() {
        return this.roleApi;
    }

    public final SnapshotApi snapshots() {
        return this.snapshotApi;
    }

    public final StatusApi status() {
        return this.statusApi;
    }

    public final SubitemApi subitems() {
        return this.subitemApi;
    }

    public final SubpictureApi subpictures() {
        return this.subpictureApi;
    }

    public final TeletextApi teletext() {
        return this.teletextApi;
    }

    public final TitleApi titles() {
        return this.titleApi;
    }

    public final VideoApi video() {
        return this.videoApi;
    }

    public final boolean setRenderer(RendererItem rendererItem) {
        boolean result;
        if (rendererItem != null && !rendererItem.hold()) {
            return false;
        }
        libvlc_renderer_item_t rendererItemInstance = rendererItem != null ? rendererItem.rendererItemInstance() : null;
        boolean bl = result = LibVlc.libvlc_media_player_set_renderer(this.mediaPlayerInstance, rendererItemInstance) == 0;
        if (result) {
            if (this.renderer != null) {
                this.renderer.release();
            }
            this.renderer = rendererItem;
        } else if (rendererItem != null) {
            rendererItem.release();
        }
        return result;
    }

    public final Object userData() {
        return this.userData;
    }

    public final void userData(Object userData) {
        this.userData = userData;
    }

    public final void submit(Runnable r) {
        this.executor.submit(r);
    }

    public final void release() {
        this.executor.release();
        this.onBeforeRelease();
        this.audioApi.release();
        this.chapterApi.release();
        this.controlsApi.release();
        this.eventApi.release();
        this.logoApi.release();
        this.marqueeApi.release();
        this.mediaApi.release();
        this.menuApi.release();
        this.roleApi.release();
        this.snapshotApi.release();
        this.statusApi.release();
        this.subitemApi.release();
        this.subpictureApi.release();
        this.teletextApi.release();
        this.titleApi.release();
        this.videoApi.release();
        LibVlc.libvlc_media_player_release(this.mediaPlayerInstance);
        this.onAfterRelease();
    }

    protected void onBeforePlay() {
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }

    public final libvlc_media_player_t mediaPlayerInstance() {
        return this.mediaPlayerInstance;
    }
}

