/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.base;

import com.sun.jna.ptr.IntByReference;
import java.awt.Dimension;
import java.util.List;
import me.lib720.caprica.vlcj.binding.internal.libvlc_video_adjust_option_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_video_viewpoint_t;
import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import me.lib720.caprica.vlcj.binding.support.strings.NativeString;
import me.lib720.caprica.vlcj.player.base.BaseApi;
import me.lib720.caprica.vlcj.player.base.DeinterlaceMode;
import me.lib720.caprica.vlcj.player.base.Descriptions;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;
import me.lib720.caprica.vlcj.player.base.Position;
import me.lib720.caprica.vlcj.player.base.TrackDescription;
import me.lib720.caprica.vlcj.player.base.Viewpoint;

public final class VideoApi
extends BaseApi {
    VideoApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void setDeinterlace(DeinterlaceMode deinterlaceMode) {
        LibVlc.libvlc_video_set_deinterlace(this.mediaPlayerInstance, deinterlaceMode != null ? deinterlaceMode.stringValue() : null);
    }

    public void setAdjustVideo(boolean adjustVideo) {
        LibVlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue(), adjustVideo ? 1 : 0);
    }

    public boolean isAdjustVideo() {
        return LibVlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue()) == 1;
    }

    public float contrast() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue());
    }

    public void setContrast(float contrast) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue(), contrast);
    }

    public float brightness() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue());
    }

    public void setBrightness(float brightness) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue(), brightness);
    }

    public float hue() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue());
    }

    public void setHue(float hue) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue(), hue);
    }

    public float saturation() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue());
    }

    public void setSaturation(float saturation) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue(), saturation);
    }

    public float gamma() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue());
    }

    public void setGamma(float gamma) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue(), gamma);
    }

    public void setVideoTitleDisplay(Position position, int timeout) {
        LibVlc.libvlc_media_player_set_video_title_display(this.mediaPlayerInstance, position.intValue(), timeout);
    }

    public String aspectRatio() {
        return NativeString.copyAndFreeNativeString(LibVlc.libvlc_video_get_aspect_ratio(this.mediaPlayerInstance));
    }

    public void setAspectRatio(String aspectRatio) {
        LibVlc.libvlc_video_set_aspect_ratio(this.mediaPlayerInstance, aspectRatio);
    }

    public float scale() {
        return LibVlc.libvlc_video_get_scale(this.mediaPlayerInstance);
    }

    public void setScale(float factor) {
        LibVlc.libvlc_video_set_scale(this.mediaPlayerInstance, factor);
    }

    public String cropGeometry() {
        return NativeString.copyAndFreeNativeString(LibVlc.libvlc_video_get_crop_geometry(this.mediaPlayerInstance));
    }

    public void setCropGeometry(String cropGeometry) {
        LibVlc.libvlc_video_set_crop_geometry(this.mediaPlayerInstance, cropGeometry);
    }

    public Dimension videoDimension() {
        IntByReference px = new IntByReference();
        IntByReference py = new IntByReference();
        int result = LibVlc.libvlc_video_get_size(this.mediaPlayerInstance, 0, px, py);
        if (result == 0) {
            return new Dimension(px.getValue(), py.getValue());
        }
        return null;
    }

    public int trackCount() {
        return LibVlc.libvlc_video_get_track_count(this.mediaPlayerInstance);
    }

    public int track() {
        return LibVlc.libvlc_video_get_track(this.mediaPlayerInstance);
    }

    public int setTrack(int track) {
        LibVlc.libvlc_video_set_track(this.mediaPlayerInstance, track);
        return this.track();
    }

    public Viewpoint newViewpoint() {
        libvlc_video_viewpoint_t viewpoint = LibVlc.libvlc_video_new_viewpoint();
        if (viewpoint != null) {
            return new Viewpoint(viewpoint);
        }
        return null;
    }

    public boolean updateViewpoint(Viewpoint viewpoint, boolean absolute) {
        return LibVlc.libvlc_video_update_viewpoint(this.mediaPlayerInstance, viewpoint.viewpoint(), absolute ? 1 : 0) == 0;
    }

    public List<TrackDescription> trackDescriptions() {
        return Descriptions.videoTrackDescriptions(this.mediaPlayerInstance);
    }
}

