/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.github.kiulian.downloader.downloader.response;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.lib720.github.kiulian.downloader.downloader.response.Response;
import me.lib720.github.kiulian.downloader.downloader.response.ResponseStatus;

public class ResponseImpl<T>
implements Response<T> {
    private Future<T> data;
    private Throwable error;

    private ResponseImpl(Future<T> data, Throwable error) {
        this.data = data;
        this.error = error;
    }

    public static <T> ResponseImpl<T> from(final T data) {
        Future future = new Future<T>(){

            @Override
            public T get(long timeout, TimeUnit unit) {
                return this.get();
            }

            @Override
            public T get() {
                return data;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }
        };
        return ResponseImpl.fromFuture(future);
    }

    public static <T> ResponseImpl<T> fromFuture(Future<T> data) {
        return new ResponseImpl<T>(data, null);
    }

    public static <T> ResponseImpl<T> error(Throwable throwable) {
        return new ResponseImpl<T>(null, throwable);
    }

    @Override
    public T data() {
        if (this.data != null) {
            try {
                return this.data.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.error = e;
            }
        }
        return null;
    }

    @Override
    public T data(long timeout, TimeUnit unit) throws TimeoutException {
        if (this.data != null) {
            try {
                return this.data.get(timeout, unit);
            }
            catch (InterruptedException | ExecutionException e) {
                this.error = e;
            }
        }
        return null;
    }

    @Override
    public Throwable error() {
        if (this.data != null) {
            try {
                this.data.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.error = e;
                return e;
            }
        }
        return this.error;
    }

    @Override
    public ResponseStatus status() {
        if (this.error != null) {
            return ResponseStatus.error;
        }
        if (this.data != null) {
            if (this.data.isCancelled()) {
                return ResponseStatus.canceled;
            }
            try {
                this.data.get(1L, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException e) {
                return ResponseStatus.canceled;
            }
            catch (TimeoutException e) {
                return ResponseStatus.downloading;
            }
            catch (InterruptedException | ExecutionException e) {
                this.error = e;
                return ResponseStatus.error;
            }
            return ResponseStatus.completed;
        }
        return ResponseStatus.error;
    }

    @Override
    public boolean ok() {
        if (this.error != null) {
            return false;
        }
        try {
            this.data.get();
            return true;
        }
        catch (CancellationException cancellationException) {
        }
        catch (Exception e) {
            this.error = e;
        }
        return false;
    }

    @Override
    public boolean cancel() {
        if (this.error != null) {
            return false;
        }
        return this.data.cancel(true);
    }
}

