/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.jackson.databind.deser.impl;

import java.io.Serializable;
import me.lib720.jackson.databind.BeanProperty;
import me.lib720.jackson.databind.DeserializationContext;
import me.lib720.jackson.databind.JavaType;
import me.lib720.jackson.databind.JsonMappingException;
import me.lib720.jackson.databind.PropertyName;
import me.lib720.jackson.databind.deser.NullValueProvider;
import me.lib720.jackson.databind.exc.InvalidNullException;
import me.lib720.jackson.databind.util.AccessPattern;

public class NullsFailProvider
implements NullValueProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyName _name;
    protected final JavaType _type;

    protected NullsFailProvider(PropertyName name, JavaType type) {
        this._name = name;
        this._type = type;
    }

    public static NullsFailProvider constructForProperty(BeanProperty prop) {
        return NullsFailProvider.constructForProperty(prop, prop.getType());
    }

    public static NullsFailProvider constructForProperty(BeanProperty prop, JavaType type) {
        return new NullsFailProvider(prop.getFullName(), type);
    }

    public static NullsFailProvider constructForRootValue(JavaType t) {
        return new NullsFailProvider(null, t);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        throw InvalidNullException.from(ctxt, this._name, this._type);
    }
}

