/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.jackson.databind.ext;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import me.lib720.jackson.core.JsonGenerator;
import me.lib720.jackson.core.JsonToken;
import me.lib720.jackson.core.type.WritableTypeId;
import me.lib720.jackson.databind.JavaType;
import me.lib720.jackson.databind.JsonMappingException;
import me.lib720.jackson.databind.SerializerProvider;
import me.lib720.jackson.databind.annotation.JacksonStdImpl;
import me.lib720.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import me.lib720.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import me.lib720.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import me.lib720.jackson.databind.jsontype.TypeSerializer;
import me.lib720.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public class SqlBlobSerializer
extends StdScalarSerializer<Blob> {
    public SqlBlobSerializer() {
        super(Blob.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Blob value) {
        return value == null;
    }

    @Override
    public void serialize(Blob value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        this._writeValue(value, gen, ctxt);
    }

    @Override
    public void serializeWithType(Blob value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this._writeValue(value, gen, ctxt);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    protected void _writeValue(Blob value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        InputStream in = null;
        try {
            in = value.getBinaryStream();
        }
        catch (SQLException e) {
            ctxt.reportMappingProblem(e, "Failed to access `java.sql.Blob` value to write as binary value", new Object[0]);
        }
        gen.writeBinary(ctxt.getConfig().getBase64Variant(), in, -1);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

