/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import me.lib720.jackson.core.JsonGenerator;
import me.lib720.jackson.core.JsonToken;
import me.lib720.jackson.core.type.WritableTypeId;
import me.lib720.jackson.databind.JavaType;
import me.lib720.jackson.databind.JsonMappingException;
import me.lib720.jackson.databind.JsonNode;
import me.lib720.jackson.databind.SerializerProvider;
import me.lib720.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import me.lib720.jackson.databind.jsontype.TypeSerializer;
import me.lib720.jackson.databind.ser.std.StdSerializer;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

