/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.audio;

import java.awt.Dimension;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import org.jetbrains.annotations.NotNull;

public abstract class AudioPlayer {
    protected String url;

    protected void compat(String url) {
        String compat = WaterMediaAPI.urlPatch(url);
        this.url = compat != null ? compat : url;
    }

    public void start(@NotNull CharSequence url) {
        this.compat(url.toString());
    }

    public void prepare(@NotNull CharSequence url) {
        this.compat(url.toString());
    }

    public abstract void play();

    public abstract void pause();

    public abstract void setPauseMode(boolean var1);

    public abstract void stop();

    public abstract void seekTo(long var1);

    public abstract void seekFastTo(long var1);

    public abstract void seekGameTicksTo(int var1);

    public abstract void seekGameTickFastTo(int var1);

    public abstract long getDuration();

    public abstract int getGameTickDuration();

    public abstract long getTime();

    public abstract int getGameTickTime();

    public abstract boolean isSeekable();

    public abstract void setRepeatMode(boolean var1);

    public abstract boolean getRepeatMode();

    public abstract boolean isPlaying();

    public abstract boolean isValid();

    public abstract Dimension getDimensions();

    public abstract void setSpeed(float var1);

    public abstract void fastFoward();

    public abstract void rewind();

    public synchronized void fastBackward() {
        this.rewind();
    }

    public abstract void setVolume(int var1);

    public abstract int getVolume();

    public abstract void mute();

    public abstract void unmute();

    public abstract void setMuteMode(boolean var1);

    public abstract boolean isPodcast();

    public abstract void release();
}

