/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.patch;

import java.net.URL;
import java.util.regex.Pattern;
import me.srrapero720.watermedia.api.url.URLPatch;
import me.srrapero720.watermedia.api.url.patch.util.onedrive.OneDriveUtil;
import org.jetbrains.annotations.NotNull;

public class OnedrivePatch
extends URLPatch {
    private static final Pattern ONE_DRIVE_URL_PATTERN = Pattern.compile("^https://1drv.ms/[a-z]/[a-zA-Z0-9!_-]+$");

    @Override
    public boolean isValid(@NotNull URL url) {
        return ONE_DRIVE_URL_PATTERN.matcher(url.toString()).matches();
    }

    @Override
    public String patch(@NotNull URL url) throws URLPatch.PatchingUrlException {
        super.patch(url);
        try {
            return OneDriveUtil.getDownloableItem(url.toString()).getUrl();
        }
        catch (Exception e) {
            throw new URLPatch.PatchingUrlException(url.toString(), (Throwable)e);
        }
    }
}

