/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.patch;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import me.srrapero720.watermedia.api.url.URLPatch;
import me.srrapero720.watermedia.api.url.patch.util.twitch.TwitchUtil;
import org.jetbrains.annotations.NotNull;

public class TwitchPatch
extends URLPatch {
    @Override
    public boolean isValid(@NotNull URL url) {
        return (url.getHost().equals("www.twitch.tv") || url.getHost().equals("twitch.tv")) && url.getPath().startsWith("/");
    }

    @Override
    public String patch(@NotNull URL url) throws URLPatch.PatchingUrlException {
        super.patch(url);
        try {
            String path = url.getPath();
            if (path.startsWith("/videos/")) {
                return TwitchUtil.getVod(path.substring(8)).get(0).getUrl();
            }
            return TwitchUtil.getStream(path.substring(1)).get(0).getUrl();
        }
        catch (Exception e) {
            throw new URLPatch.PatchingUrlException(url, (Throwable)e);
        }
    }

    static {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }
}

