/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.patch;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lib720.github.kiulian.downloader.YoutubeDownloader;
import me.lib720.github.kiulian.downloader.downloader.request.RequestVideoInfo;
import me.lib720.github.kiulian.downloader.model.videos.VideoDetails;
import me.lib720.github.kiulian.downloader.model.videos.VideoInfo;
import me.lib720.github.kiulian.downloader.model.videos.formats.AudioFormat;
import me.lib720.github.kiulian.downloader.model.videos.formats.VideoFormat;
import me.srrapero720.watermedia.api.url.URLPatch;
import me.srrapero720.watermedia.api.url.patch.util.StreamQuality;
import org.jetbrains.annotations.NotNull;

public class YoutubePatch
extends URLPatch {
    private static final Pattern PATTERN = Pattern.compile("(?:youtu\\.be/|youtube\\.com/(?:embed/|v/|shorts/|feeds/api/videos/|watch\\?v=|watch\\?.+&v=))([^/?&#]+)");

    @Override
    public boolean isValid(@NotNull URL url) {
        return url.getHost().endsWith("youtube.com") || url.getHost().endsWith("youtu.be");
    }

    @Override
    public String patch(@NotNull URL url) throws URLPatch.PatchingUrlException {
        super.patch(url);
        Matcher matcher = PATTERN.matcher(url.toString());
        if (matcher.find()) {
            try {
                String videoId = matcher.group(1);
                VideoInfo videoInfo = new YoutubeDownloader().getVideoInfo(new RequestVideoInfo(videoId)).data();
                VideoDetails videoDetails = videoInfo.details();
                if (videoDetails.isLive()) {
                    String ytLivePlaylist = this.fetchLivePlaylist(videoDetails.liveUrl());
                    if (ytLivePlaylist != null) {
                        return StreamQuality.parse(ytLivePlaylist).get(0).getUrl();
                    }
                } else {
                    VideoFormat bestWithAudio = videoInfo.bestVideoWithAudioFormat();
                    if (bestWithAudio != null) {
                        return bestWithAudio.url();
                    }
                    VideoFormat bestWithoutAudio = videoInfo.bestVideoFormat();
                    if (bestWithoutAudio != null) {
                        return bestWithoutAudio.url();
                    }
                    AudioFormat bestWithoutVideo = videoInfo.bestAudioFormat();
                    if (bestWithoutVideo != null) {
                        return bestWithoutVideo.url();
                    }
                }
                return "https://www.youtube.com/watch?v=" + videoId;
            }
            catch (Exception e) {
                throw new URLPatch.PatchingUrlException(url.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private String fetchLivePlaylist(String url) throws IOException {
        URL apiUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
        conn.setRequestMethod("GET");
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            return null;
        }
        return new String(conn.getInputStream().readAllBytes());
    }
}

