/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.patch.util.twitter;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TwitterVideoExtractor {
    public List<String> extractMp4s(String jsonString, String tweetUrl) {
        Pattern amplitudePattern = Pattern.compile("(https://video.twimg.com/amplify_video/(\\d+)/vid/(\\d+x\\d+)/[^.]+.mp4\\?tag=\\d+)");
        Pattern extTwPattern = Pattern.compile("(https://video.twimg.com/ext_tw_video/(\\d+)/pu/vid/(\\d+x\\d+)/[^.]+.mp4\\?tag=\\d+)");
        Pattern tweetVideoPattern = Pattern.compile("https://video.twimg.com/tweet_video/[^\"]+");
        Pattern containerPattern = Pattern.compile("https://video.twimg.com/[^\"].*container=fmp4");
        String mediaId = this.getAssociatedMediaId(jsonString, tweetUrl);
        List<String> matches = this.findMatches(jsonString, amplitudePattern);
        matches.addAll(this.findMatches(jsonString, extTwPattern));
        List<String> containerMatches = this.findMatches(jsonString, containerPattern);
        List<String> tweetVideoMatches = this.findMatches(jsonString, tweetVideoPattern);
        if (matches.size() == 0 && tweetVideoMatches.size() > 0) {
            return tweetVideoMatches;
        }
        HashMap results = new HashMap();
        for (String string : matches) {
            int[] theirDims;
            Matcher matcher = amplitudePattern.matcher(string);
            if (!matcher.find()) continue;
            String url = matcher.group(1);
            String tweetId = matcher.group(2);
            String resolution = matcher.group(3);
            if (!results.containsKey(tweetId)) {
                results.put(tweetId, new HashMap());
                ((Map)results.get(tweetId)).put("resolution", resolution);
                ((Map)results.get(tweetId)).put("url", url);
                continue;
            }
            int[] myDims = Arrays.stream(resolution.split("x")).mapToInt(Integer::parseInt).toArray();
            if (myDims[0] * myDims[1] <= (theirDims = Arrays.stream(((String)((Map)results.get(tweetId)).get("resolution")).split("x")).mapToInt(Integer::parseInt).toArray())[0] * theirDims[1]) continue;
            ((Map)results.get(tweetId)).put("resolution", resolution);
            ((Map)results.get(tweetId)).put("url", url);
        }
        containerMatches.replaceAll(s -> s.split("\\?")[0]);
        if (mediaId != null) {
            ArrayList<String> allUrls = new ArrayList<String>();
            for (Object value : results.values()) {
                allUrls.add(((String)value.get("url")).split("\\?")[0]);
            }
            allUrls.addAll(containerMatches);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String url : allUrls) {
                if (!url.contains(mediaId)) continue;
                arrayList.add(url);
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
        }
        if (!containerMatches.isEmpty()) {
            return containerMatches;
        }
        ArrayList<String> resultUrls = new ArrayList<String>();
        for (Object value : results.values()) {
            resultUrls.add(((String)value.get("url")).split("\\?")[0]);
        }
        return resultUrls;
    }

    private List<String> findMatches(String inputString, Pattern pattern) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = pattern.matcher(inputString);
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    public String getAssociatedMediaId(String jsonString, String tweetUrl) {
        String sid = this.getTweetStatusId(tweetUrl);
        Pattern pattern = Pattern.compile("\"expanded_url\"\\s*:\\s*\"https://twitter\\.com/[^/]+/status/" + sid + "/[^\"]+\",\\s*\"id_str\"\\s*:\\s*\"\\d+\",");
        Matcher matcher = pattern.matcher(jsonString);
        if (matcher.find()) {
            String target = matcher.group();
            target = target.substring(0, target.length() - 1);
            JsonObject jsonObject = JsonParser.parseString((String)("{" + target + "}")).getAsJsonObject();
            return jsonObject.get("id_str").getAsString();
        }
        return null;
    }

    public String getTweetStatusId(String tweetUrl) {
        Pattern pattern;
        Matcher matcher;
        String sidPattern = "https://twitter\\.com/[^/]+/status/(\\d+)";
        if (((String)tweetUrl).charAt(((String)tweetUrl).length() - 1) != '/') {
            tweetUrl = (String)tweetUrl + "/";
        }
        if ((matcher = (pattern = Pattern.compile(sidPattern)).matcher((CharSequence)tweetUrl)).find()) {
            return matcher.group(1);
        }
        System.out.println("error, could not get status id from this tweet url: " + (String)tweetUrl);
        System.exit(1);
        return null;
    }
}

