/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.video;

import java.awt.Dimension;
import javax.annotation.Nullable;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.media.InfoApi;
import me.lib720.caprica.vlcj.media.MediaType;
import me.lib720.caprica.vlcj.player.base.State;
import me.lib720.caprica.vlcj.player.component.CallbackMediaPlayerComponent;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.external.ThreadUtil;
import me.srrapero720.watermedia.api.video.VideoPlayer;
import me.srrapero720.watermedia.core.videolan.VideoLAN;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Deprecated
public class SafeVideoLANPlayer
extends VideoPlayer {
    private static final Marker IT = MarkerFactory.getMarker((String)"SafeVideoLanPlayer");
    private volatile CallbackMediaPlayerComponent player;
    private volatile boolean safe = true;

    public CallbackMediaPlayerComponent raw() {
        return this.player;
    }

    public SafeVideoLANPlayer(@Nullable MediaPlayerFactory factory, @Nullable RenderCallback renderCallback, @Nullable BufferFormatCallback bufferFormatCallback) {
        if (factory == null) {
            factory = VideoLAN.factory();
        }
        if (WaterMediaAPI.isVLCReady()) {
            this.player = this.init(factory, renderCallback, bufferFormatCallback);
        } else {
            WaterMedia.LOGGER.error(IT, "Failed to create CallbackMediaPlayerComponent because VLC is not loaded");
        }
    }

    @Override
    public void start(@NotNull CharSequence url) {
        this.start(url, new String[0]);
    }

    public synchronized void start(CharSequence url, String[] vlcArgs) {
        if (this.player == null) {
            return;
        }
        ThreadUtil.threadTry(() -> {
            SafeVideoLANPlayer safeVideoLANPlayer = this;
            synchronized (safeVideoLANPlayer) {
                if (this.player == null) {
                    return;
                }
                this.safe = false;
                super.start(url.toString());
                this.player.mediaPlayer().media().start(this.url, vlcArgs);
                this.safe = true;
            }
        }, null, null);
    }

    @Override
    public void prepare(@NotNull CharSequence url) {
        this.prepare(url, new String[0]);
    }

    public void prepare(@NotNull CharSequence url, String[] vlcArgs) {
        if (this.player == null) {
            return;
        }
        ThreadUtil.threadTry(() -> {
            SafeVideoLANPlayer safeVideoLANPlayer = this;
            synchronized (safeVideoLANPlayer) {
                if (this.player == null) {
                    return;
                }
                this.safe = false;
                super.start(url.toString());
                if (this.player != null) {
                    this.player.mediaPlayer().media().prepare(this.url, vlcArgs);
                }
                this.safe = true;
            }
        }, null, null);
    }

    @Override
    public void play() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().play();
    }

    @Override
    public void pause() {
        if (this.player == null) {
            return;
        }
        if (this.player.mediaPlayer().status().canPause()) {
            this.player.mediaPlayer().controls().pause();
        }
    }

    @Override
    public void setPauseMode(boolean isPaused) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setPause(isPaused);
    }

    @Override
    public void stop() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().stop();
    }

    @Override
    public void seekTo(long time) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime(time);
    }

    @Override
    public void seekFastTo(long ticks) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime(ticks);
    }

    @Override
    public void seekGameTicksTo(int ticks) {
        if (this.player == null) {
            return;
        }
        long time = WaterMediaAPI.gameTicksToMs(ticks);
        this.player.mediaPlayer().controls().setTime(time);
    }

    @Override
    public void seekGameTickFastTo(int ticks) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime(WaterMediaAPI.gameTicksToMs(ticks));
    }

    @Override
    public void setRepeatMode(boolean repeatMode) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setRepeat(repeatMode);
    }

    @Override
    public boolean isValid() {
        if (this.player == null) {
            return false;
        }
        return this.player.mediaPlayer().media().isValid();
    }

    @Override
    public boolean isSafeToUse() {
        return this.safe;
    }

    @Override
    public Dimension getDimensions() {
        if (this.player == null) {
            return null;
        }
        return this.player.mediaPlayer().video().videoDimension();
    }

    @Override
    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.player.mediaPlayer().status().isPlaying() || this.getRawPlayerState().equals((Object)State.PLAYING);
    }

    @Override
    public boolean getRepeatMode() {
        if (this.player == null) {
            return false;
        }
        return this.player.mediaPlayer().controls().getRepeat();
    }

    @Override
    public void fastFoward() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().skipTime(5L);
    }

    @Override
    public void setSpeed(float rate) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setRate(rate);
    }

    @Override
    public void rewind() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().skipTime(-5L);
    }

    @Override
    public synchronized void setVolume(int volume) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().audio().setVolume(volume);
        if (volume == 0 && !this.player.mediaPlayer().audio().isMute()) {
            this.player.mediaPlayer().audio().setMute(true);
        } else if (volume > 0 && this.player.mediaPlayer().audio().isMute()) {
            this.player.mediaPlayer().audio().setMute(false);
        }
    }

    @Override
    public int getVolume() {
        if (this.player == null) {
            return 0;
        }
        return this.player.mediaPlayer().audio().volume();
    }

    @Override
    public void mute() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().audio().setMute(true);
    }

    @Override
    public void unmute() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().audio().setMute(false);
    }

    @Override
    public void setMuteMode(boolean mode) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().audio().setMute(mode);
    }

    @Override
    public boolean isStream() {
        if (this.player == null) {
            return false;
        }
        InfoApi mediaInfo = this.player.mediaPlayer().media().info();
        return mediaInfo != null && (mediaInfo.type().equals((Object)MediaType.STREAM) || mediaInfo.mrl().endsWith(".m3u") || mediaInfo.mrl().endsWith(".m3u8"));
    }

    public State getRawPlayerState() {
        if (this.player == null) {
            return State.NOTHING_SPECIAL;
        }
        return this.player.mediaPlayer().status().state();
    }

    @Override
    public long getDuration() {
        if (this.player == null) {
            return 0L;
        }
        return this.player.mediaPlayer().status().length();
    }

    @Override
    public int getGameTickDuration() {
        if (this.player == null) {
            return 0;
        }
        return WaterMediaAPI.msToGameTicks(this.player.mediaPlayer().status().length());
    }

    @Deprecated
    public long getMediaInfoDuration() {
        if (this.player == null) {
            return 0L;
        }
        InfoApi info = this.player.mediaPlayer().media().info();
        if (info != null) {
            return info.duration();
        }
        return 0L;
    }

    @Deprecated
    public int getGameTickMediaInfoDuration() {
        if (this.player == null) {
            return 0;
        }
        InfoApi info = this.player.mediaPlayer().media().info();
        if (info != null) {
            return WaterMediaAPI.msToGameTicks(info.duration());
        }
        return 0;
    }

    @Override
    public long getTime() {
        if (this.player == null) {
            return 0L;
        }
        return this.player.mediaPlayer().status().time();
    }

    @Override
    public int getGameTickTime() {
        if (this.player == null) {
            return 0;
        }
        return WaterMediaAPI.msToGameTicks(this.player.mediaPlayer().status().time());
    }

    @Override
    public boolean isSeekable() {
        if (this.player == null) {
            return false;
        }
        return this.player.mediaPlayer().status().isSeekable();
    }

    @Override
    public void release() {
        if (this.player == null) {
            return;
        }
        this.stop();
        CallbackMediaPlayerComponent tempPlayer = this.player;
        this.player = null;
        ThreadUtil.threadTryWithLowPrior(() -> {
            SafeVideoLANPlayer safeVideoLANPlayer = this;
            synchronized (safeVideoLANPlayer) {
                if (tempPlayer == null) {
                    return;
                }
                this.safe = false;
                tempPlayer.mediaPlayer().release();
            }
        });
    }

    private CallbackMediaPlayerComponent init(MediaPlayerFactory factory, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback) {
        return new CallbackMediaPlayerComponent(factory, null, null, false, renderCallback, bufferFormatCallback, null);
    }
}

