/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.mixin.BlockPropertiesAccessor;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.util.TriPredicate;

public class BlockProperties {
    private final Material material;
    private final MaterialColor mapColor;
    private boolean hasCollision = true;
    private boolean canOcclude = true;
    private SoundType soundType = SoundType.f_56742_;
    private ToIntFunction<BlockState> lightLevel = state -> 0;
    private float explosionResistance;
    private float destroyTime;
    private boolean requiresCorrectTool = false;
    private boolean ticksRandomly = false;
    private float friction = 0.6f;
    private float speedFactor = 1.0f;
    private float jumpFactor = 1.0f;
    private boolean isAir = false;
    private TriPredicate<BlockState, BlockGetter, BlockPos> isRedstoneConductor = (state, level, pos) -> state.m_60767_().m_76337_() && state.m_60838_(level, pos);
    private TriPredicate<BlockState, BlockGetter, BlockPos> isSuffocating = (state, level, pos) -> state.m_60767_().m_76334_() && state.m_60838_(level, pos);
    private boolean hasDynamicShape = false;
    private boolean noLootTable = false;
    private Supplier<ResourceLocation> lootTableSupplier;

    public static BlockProperties create(Material material, MaterialColor color) {
        return new BlockProperties(material, color);
    }

    public static BlockProperties create(Material material, DyeColor color) {
        return new BlockProperties(material, color.m_41069_());
    }

    public static BlockProperties create(Material material) {
        return new BlockProperties(material, material.m_76339_());
    }

    public static BlockProperties copy(Block block) {
        BlockBehaviour.Properties sourceProperties = block.f_60439_;
        BlockProperties properties = BlockProperties.create(sourceProperties.f_60882_, block.m_60590_());
        properties.hasCollision = sourceProperties.f_60884_;
        properties.canOcclude = block.m_49966_().m_60815_();
        properties.soundType = block.m_49962_(block.m_49966_());
        properties.lightLevel = sourceProperties.f_60886_;
        properties.explosionResistance = block.m_7325_();
        properties.destroyTime = block.m_155943_();
        properties.requiresCorrectTool = block.m_49966_().m_60834_();
        properties.ticksRandomly = block.m_6724_(block.m_49966_());
        properties.friction = block.m_49958_();
        properties.speedFactor = block.m_49961_();
        properties.jumpFactor = block.m_49964_();
        properties.isAir = block.m_49966_().m_60795_();
        properties.isRedstoneConductor = (arg_0, arg_1, arg_2) -> ((BlockBehaviour.StatePredicate)sourceProperties.f_60898_).m_61035_(arg_0, arg_1, arg_2);
        properties.isSuffocating = (arg_0, arg_1, arg_2) -> ((BlockBehaviour.StatePredicate)sourceProperties.f_60899_).m_61035_(arg_0, arg_1, arg_2);
        properties.hasDynamicShape = block.m_49967_();
        properties.lootTableSupplier = sourceProperties.f_60894_ != null ? () -> sourceProperties.f_60894_ : ((BlockPropertiesAccessor)sourceProperties).getLootTableSupplier();
        return properties;
    }

    private BlockProperties(Material material, MaterialColor color) {
        this.material = material;
        this.mapColor = color;
    }

    public BlockProperties noCollision() {
        this.hasCollision = false;
        this.canOcclude = false;
        return this;
    }

    public BlockProperties noOcclusion() {
        this.canOcclude = false;
        return this;
    }

    public BlockProperties sound(SoundType soundTypeIn) {
        this.soundType = soundTypeIn;
        return this;
    }

    public BlockProperties lightLevel(ToIntFunction<BlockState> stateLightFunction) {
        this.lightLevel = stateLightFunction;
        return this;
    }

    public BlockProperties lightLevel(int light) {
        this.lightLevel = state -> light;
        return this;
    }

    public BlockProperties explosionResistance(float resistance) {
        this.explosionResistance = Math.max(0.0f, resistance);
        return this;
    }

    public BlockProperties destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockProperties requiresCorrectTool() {
        this.requiresCorrectTool = true;
        return this;
    }

    public BlockProperties randomTicks() {
        this.ticksRandomly = true;
        return this;
    }

    public BlockProperties friction(float friction) {
        this.friction = friction;
        return this;
    }

    public BlockProperties speedFactor(float factor) {
        this.speedFactor = factor;
        return this;
    }

    public BlockProperties jumpFactor(float factor) {
        this.jumpFactor = factor;
        return this;
    }

    public BlockProperties air() {
        this.isAir = true;
        return this;
    }

    public BlockProperties isRedstoneConductor(TriPredicate<BlockState, BlockGetter, BlockPos> isRedstoneConductor) {
        this.isRedstoneConductor = isRedstoneConductor;
        return this;
    }

    public BlockProperties isRedstoneConductor(boolean isRedstoneConductor) {
        this.isRedstoneConductor = (state, blockGetter, pos) -> isRedstoneConductor;
        return this;
    }

    public BlockProperties isSuffocating(TriPredicate<BlockState, BlockGetter, BlockPos> isSuffocating) {
        this.isSuffocating = isSuffocating;
        return this;
    }

    public BlockProperties isSuffocating(boolean isSuffocating) {
        this.isSuffocating = (state, blockGetter, pos) -> isSuffocating;
        return this;
    }

    public BlockProperties dynamicShape() {
        this.hasDynamicShape = true;
        return this;
    }

    public BlockProperties noLootTable() {
        this.noLootTable = true;
        this.lootTableSupplier = null;
        return this;
    }

    public BlockProperties lootTable(ResourceLocation lootTable) {
        this.noLootTable = false;
        this.lootTableSupplier = () -> lootTable;
        return this;
    }

    public BlockProperties lootTableFrom(Supplier<Block> block) {
        this.noLootTable = false;
        this.lootTableSupplier = block == null ? null : () -> ((Block)block.get()).m_60589_();
        return this;
    }

    @Deprecated
    public BlockBehaviour.Properties toUnderlying() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60944_((Material)this.material, (MaterialColor)this.mapColor);
        if (!this.hasCollision) {
            properties.m_60910_();
        }
        properties.m_60918_(this.soundType);
        properties.m_60953_(this.lightLevel);
        properties.m_60978_(this.explosionResistance);
        properties.m_155954_(this.destroyTime);
        if (this.requiresCorrectTool) {
            properties.m_60999_();
        }
        if (this.ticksRandomly) {
            properties.m_60977_();
        }
        properties.m_60911_(this.friction);
        properties.m_60956_(this.speedFactor);
        properties.m_60967_(this.jumpFactor);
        if (this.noLootTable) {
            properties.m_222994_();
        }
        ((BlockPropertiesAccessor)properties).setLootTableSupplier(this.lootTableSupplier);
        if (!this.canOcclude) {
            properties.m_60955_();
        }
        if (this.isAir) {
            properties.m_60996_();
        }
        properties.m_60924_((arg_0, arg_1, arg_2) -> this.isRedstoneConductor.test(arg_0, arg_1, arg_2));
        properties.m_60960_((arg_0, arg_1, arg_2) -> this.isSuffocating.test(arg_0, arg_1, arg_2));
        properties.m_60971_((arg_0, arg_1, arg_2) -> this.isSuffocating.test(arg_0, arg_1, arg_2));
        if (this.hasDynamicShape) {
            properties.m_60988_();
        }
        return properties;
    }
}

