/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.block;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.Materials;
import shetiphian.core.common.ToolHelper;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.common.block.HitBoxHelper;
import shetiphian.endertanks.common.item.ItemEnderBucket;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class BlockEnderTank
extends Block
implements EntityBlock,
IColored {
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])Direction.values());
    private static final EnumProperty<EnumType> VARIANT = EnumProperty.m_61587_((String)"variant", EnumType.class);
    private static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final HashMap<Direction, VoxelShape[]> SHAPES = new HashMap();

    public BlockEnderTank() {
        super(BlockBehaviour.Properties.m_60944_((Material)Materials.IMMOVABLE_TRANSLUCENT, (MaterialColor)MaterialColor.f_76365_).m_60913_(1.5f, 5.0f).m_60918_(SoundType.f_56742_).m_60955_().m_60960_((state, world, pos) -> false));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT, POWERED});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityEnderTank(pos, state);
    }

    private TileEntityEnderTank getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityEnderTank ? (TileEntityEnderTank)tile : null;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (SHAPES.isEmpty()) {
            Map<Direction, VoxelShape> tank_body = HitBoxHelper.getBody();
            Map<Direction, VoxelShape> top_ring = HitBoxHelper.getRing_Top();
            Map<Direction, VoxelShape> middle_ring = HitBoxHelper.getRing_Middle();
            Map<Direction, VoxelShape> bottom_ring = HitBoxHelper.getRing_Bottom();
            for (Direction direction : Direction.values()) {
                VoxelShape[] shapes = new VoxelShape[]{tank_body.getOrDefault(direction, Shapes.m_83040_()), top_ring.getOrDefault(direction, Shapes.m_83040_()), middle_ring.getOrDefault(direction, Shapes.m_83040_()), bottom_ring.getOrDefault(direction, Shapes.m_83040_())};
                SHAPES.put(direction, shapes);
            }
        }
        if (!SHAPES.isEmpty()) {
            return SHAPES.get(BlockEnderTank.getFacing(state))[0];
        }
        return Shapes.m_83144_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.onBlockActivated(state, world, pos, player, hand, player.m_21120_(hand), hit.m_82434_());
    }

    public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldItem, Direction face) {
        TileEntityEnderTank tankTile = this.getTile((BlockGetter)world, pos);
        if (tankTile == null) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.m_41619_() && !(heldItem.m_41720_() instanceof ItemEnderBucket) && tankTile.canUse(player)) {
            IFluidHandler tankHandler = tankTile.getEnderContainer().getTankFor(IFluidHandler.class);
            IFluidHandler containerHandler = CapabilityHelper.FLUIDS.getHandler(heldItem.m_41777_().m_41620_(1), face);
            if (tankHandler != null && containerHandler != null) {
                FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tankHandler);
                return InteractionResult.SUCCESS;
            }
        }
        if (!player.m_6144_()) {
            if (tankTile.lastClick <= System.currentTimeMillis()) {
                tankTile.lastClick = System.currentTimeMillis() + 200L;
                if (heldItem.m_41619_() || !(heldItem.m_41720_() instanceof BlockItem) && !ToolHelper.isWrench((ItemStack)heldItem)) {
                    TankInfoHelper.sendTankInfo(player, tankTile);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.m_41619_()) {
            DyeColor color;
            int subHit;
            if (tankTile.isPublic()) {
                boolean changed = false;
                if (Values.listPersonal.contains(heldItem.m_41720_())) {
                    if (((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalTanks.get()).booleanValue()) {
                        changed = true;
                        tankTile.setOwner(player, heldItem.m_41777_().m_41620_(1));
                        Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(VARIANT, (Comparable)((Object)EnumType.PRIVATE))), (boolean)true);
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.private.disabled");
                    }
                }
                if (!changed && Values.listTeam.contains(heldItem.m_41720_())) {
                    if (((Boolean)Configuration.ACCESS_SETTINGS.allowTeamTanks.get()).booleanValue()) {
                        String teamID = Function.getPlayerTeamID((Player)player);
                        if (!Strings.isNullOrEmpty((String)teamID)) {
                            changed = true;
                            tankTile.setOwner(Function.getTeamDisplayName((String)teamID), "#" + teamID, heldItem.m_41777_().m_41620_(1));
                            Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(VARIANT, (Comparable)((Object)EnumType.TEAM))), (boolean)true);
                        } else {
                            TankInfoHelper.sendError(player, "shetiphian.team.noteam");
                        }
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.team.disabled");
                    }
                }
                if (changed) {
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (!tankTile.canEdit(player)) {
                return InteractionResult.SUCCESS;
            }
            short capacity = TankHelper.getCapacityInBuckets(world, tankTile.getOwnerID(), tankTile.getCode());
            if (capacity < (Integer)Configuration.UPGRADE_SETTINGS.tankSizeMax.get()) {
                int newValue = 0;
                if (Values.listSmallCap_Single.contains(heldItem.m_41720_())) {
                    newValue = -1;
                    if (tankTile.applyItem(heldItem)) {
                        newValue = (Integer)Configuration.UPGRADE_SETTINGS.smallCapacity.get();
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                    }
                }
                if (newValue == 0 && Values.listSmallCap_Multi.contains(heldItem.m_41720_())) {
                    newValue = (Integer)Configuration.UPGRADE_SETTINGS.smallCapacity.get();
                }
                if (newValue == 0 && capacity + (Integer)Configuration.UPGRADE_SETTINGS.largeCapacity.get() <= (Integer)Configuration.UPGRADE_SETTINGS.tankSizeMax.get()) {
                    if (Values.listLargeCap_Single.contains(heldItem.m_41720_())) {
                        newValue = -1;
                        if (tankTile.applyItem(heldItem)) {
                            newValue = (Integer)Configuration.UPGRADE_SETTINGS.largeCapacity.get();
                        } else {
                            TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                        }
                    }
                    if (newValue == 0 && Values.listLargeCap_Multi.contains(heldItem.m_41720_())) {
                        newValue = (Integer)Configuration.UPGRADE_SETTINGS.largeCapacity.get();
                    }
                }
                if (newValue > 0) {
                    TankHelper.setCapacityInBuckets(world, tankTile.getOwnerID(), tankTile.getCode(), (short)(capacity + newValue));
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    TankInfoHelper.sendCapacityInfo(player, tankTile);
                    return InteractionResult.SUCCESS;
                }
            }
            if (tankTile.getPumpUpgradeCount() < (Integer)Configuration.UPGRADE_SETTINGS.tankPumpMax.get()) {
                boolean upgrade_pump = false;
                if (Values.listPump_Single.contains(heldItem.m_41720_())) {
                    if (tankTile.applyItem(heldItem)) {
                        upgrade_pump = true;
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                    }
                } else if (Values.listPump_Multi.contains(heldItem.m_41720_())) {
                    upgrade_pump = true;
                }
                if (upgrade_pump) {
                    tankTile.addPumpUpgrade(heldItem.m_41777_().m_41620_(1));
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    TankInfoHelper.sendPumpInfo(player, tankTile);
                    Function.syncTile((BlockEntity)tankTile);
                    return InteractionResult.SUCCESS;
                }
            }
            if (((Boolean)Configuration.GENERAL.enableInWorldRecoloring.get()).booleanValue() && (subHit = Function.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])SHAPES.get(state.m_61143_((Property)FACING)))) > 0 && subHit < 4 && (color = DyeHelper.getDyeColor((Item)heldItem.m_41720_())) != null && tankTile.doColorRing(color, player)) {
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                world.m_46672_(pos, (Block)this);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        return this.canHarvestBlock(state, world, pos, player) ? super.m_5880_(state, player, world, pos) : -1.0f;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isPowered = context.m_43725_().m_46753_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityEnderTank tile = this.getTile((BlockGetter)world, pos);
        if (tile != null) {
            Object code = StackHelper.getCode(stack);
            while (((String)code).length() < 3) {
                code = "0" + (String)code;
            }
            ItemStack personalItem = StackHelper.getPersonalItem(stack);
            tile.setCode((String)code);
            if (!personalItem.m_41619_()) {
                tile.setOwner(StackHelper.getOwnerName(stack), StackHelper.getOwnerID(stack), personalItem);
                Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : EnumType.PRIVATE)))), (boolean)true);
            }
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updatePoweredState(state, world, pos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighbor, BlockPos fromPos, boolean isMoving) {
        this.updatePoweredState(state, world, pos);
    }

    private void updatePoweredState(BlockState state, Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            boolean isPowered = world.m_46753_(pos);
            if ((Boolean)state.m_61143_((Property)POWERED) != isPowered) {
                Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))), (boolean)false);
            }
            if (isPowered) {
                world.m_186460_(pos, (Block)this, 20);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.updatePoweredState(state, (Level)world, pos);
        if (!world.m_5776_() && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            TileEntityEnderTank tankTile = this.getTile((BlockGetter)world, pos);
            if (tankTile != null) {
                Direction tankFacing = BlockEnderTank.getFacing(state);
                BlockPos fromPos = pos.m_121945_(tankFacing.m_122424_());
                BlockPos toPos = pos.m_121945_(tankFacing);
                int pumpCapacity = tankTile.getPumpCapacity();
                EnderContainer enderContainer = tankTile.getEnderContainer();
                HandlerRegistry.getProviders().forEach((key, provider) -> {
                    ITankHandler<?> handler = enderContainer.getOrCreateHandler((String)key);
                    if (handler != null) {
                        handler.preformPumpAction((Level)world, pos, tankFacing, fromPos, toPos, pumpCapacity, random);
                    }
                });
            }
            world.m_186460_(pos, (Block)this, 20);
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        return tile == null || tile.canEdit(player);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.canHarvestBlock(state, (BlockGetter)world, pos, player) && super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        BlockEntity builderTile = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (builderTile instanceof TileEntityEnderTank) {
            ItemStack personal;
            TileEntityEnderTank tile = (TileEntityEnderTank)builderTile;
            Entity builderEntity = (Entity)builder.m_78982_(LootContextParams.f_81455_);
            if (builderEntity != null && builderEntity.m_6144_() && !(personal = tile.getPersonalItem()).m_41619_()) {
                drops.add(personal);
            }
            drops.addAll(tile.getPumpUpgrades());
        }
        return drops;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null) {
            return StackHelper.create(Item.m_41439_((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
        }
        return new ItemStack((ItemLike)this);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null) {
            if (player != null && !player.m_6144_()) {
                if (tile.isTeam() && (player.m_150110_().f_35937_ || tile.getOwnerID().equalsIgnoreCase("#" + Function.getPlayerTeamID((Player)player)))) {
                    return StackHelper.create(Item.m_41439_((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
                if (!tile.isPublic() && (player.m_150110_().f_35937_ || tile.getOwnerID().equalsIgnoreCase(player.m_20148_().toString()))) {
                    return StackHelper.create(Item.m_41439_((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
            }
            return StackHelper.create(Item.m_41439_((Block)this), tile.getCode(), null);
        }
        return new ItemStack((ItemLike)this);
    }

    public String m_7705_() {
        return "block.endertanks.tank.public";
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation != Rotation.NONE) {
            Direction facing = BlockEnderTank.getFacing(state);
            if (rotation == Rotation.CLOCKWISE_180) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
            int value = facing.ordinal() + (rotation == Rotation.CLOCKWISE_90 ? 1 : -1);
            value = value < 0 ? 5 : (value > 5 ? 0 : value);
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.m_122376_((int)value));
        }
        return state;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        if (world.m_5776_()) {
            return 0;
        }
        TileEntityEnderTank tile = this.getTile((BlockGetter)world, pos);
        return tile != null ? tile.getComparatorOutput() : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderTank tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile((BlockGetter)data.world, data.pos)) != null) {
            int value = Mth.m_14045_((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public static Direction getFacing(BlockState state) {
        Direction facing;
        try {
            facing = (Direction)state.m_61143_((Property)FACING);
        }
        catch (Exception e) {
            facing = Direction.DOWN;
            EnderTanks.LOGGER.error("PropertyEnum 'BlockEnderTank.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + state);
        }
        return facing;
    }

    public static boolean isPowered(BlockState state) {
        boolean powered;
        try {
            powered = (Boolean)state.m_61143_((Property)POWERED);
        }
        catch (Exception e) {
            powered = false;
            EnderTanks.LOGGER.error("PropertyEnum 'BlockEnderTank.POWERED' not found in provided BlockState, returning 'false'. Provided BlockState: " + state);
        }
        return powered;
    }

    public static enum EnumType implements StringRepresentable
    {
        PUBLIC("public"),
        PRIVATE("private"),
        TEAM("team");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

