/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.coderbot.batchedentityrendering.impl.BufferSegment;
import net.coderbot.batchedentityrendering.impl.BufferSegmentRenderer;
import net.coderbot.batchedentityrendering.impl.Groupable;
import net.coderbot.batchedentityrendering.impl.MemoryTrackingBuffer;
import net.coderbot.batchedentityrendering.impl.SegmentedBufferBuilder;
import net.coderbot.batchedentityrendering.impl.ordering.GraphTranslucencyRenderOrderManager;
import net.coderbot.batchedentityrendering.impl.ordering.RenderOrderManager;
import net.coderbot.iris.fantastic.WrappingMultiBufferSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.profiling.ProfilerFiller;

public class FullyBufferedMultiBufferSource
extends MultiBufferSource.BufferSource
implements MemoryTrackingBuffer,
Groupable,
WrappingMultiBufferSource {
    private static final int NUM_BUFFERS = 32;
    private final RenderOrderManager renderOrderManager = new GraphTranslucencyRenderOrderManager();
    private final SegmentedBufferBuilder[] builders = new SegmentedBufferBuilder[32];
    private final LinkedHashMap<RenderType, Integer> affinities;
    private int drawCalls;
    private int renderTypes;
    private final BufferSegmentRenderer segmentRenderer;
    private final UnflushableWrapper unflushableWrapper;
    private final List<Function<RenderType, RenderType>> wrappingFunctionStack;
    private Function<RenderType, RenderType> wrappingFunction = null;

    public FullyBufferedMultiBufferSource() {
        super(new BufferBuilder(0), Collections.emptyMap());
        for (int i = 0; i < this.builders.length; ++i) {
            this.builders[i] = new SegmentedBufferBuilder();
        }
        this.affinities = new LinkedHashMap(32, 0.75f, true);
        this.drawCalls = 0;
        this.segmentRenderer = new BufferSegmentRenderer();
        this.unflushableWrapper = new UnflushableWrapper(this);
        this.wrappingFunctionStack = new ArrayList<Function<RenderType, RenderType>>();
    }

    public VertexConsumer m_6299_(RenderType renderType) {
        if (this.wrappingFunction != null) {
            renderType = this.wrappingFunction.apply(renderType);
        }
        this.renderOrderManager.begin(renderType);
        Integer affinity = this.affinities.get(renderType);
        if (affinity == null) {
            if (this.affinities.size() < this.builders.length) {
                affinity = this.affinities.size();
            } else {
                Iterator<Map.Entry<RenderType, Integer>> iterator = this.affinities.entrySet().iterator();
                Map.Entry<RenderType, Integer> evicted = iterator.next();
                iterator.remove();
                this.affinities.remove(evicted.getKey());
                affinity = evicted.getValue();
            }
            this.affinities.put(renderType, affinity);
        }
        return this.builders[affinity].m_6299_(renderType);
    }

    public void m_109911_() {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("collect");
        HashMap typeToSegment = new HashMap();
        for (SegmentedBufferBuilder builder : this.builders) {
            List<BufferSegment> segments = builder.getSegments();
            for (BufferSegment segment : segments) {
                typeToSegment.computeIfAbsent(segment.type(), type -> new ArrayList()).add(segment);
            }
        }
        profiler.m_6182_("resolve ordering");
        Iterable<RenderType> renderOrder = this.renderOrderManager.getRenderOrder();
        profiler.m_6182_("draw buffers");
        for (RenderType type2 : renderOrder) {
            type2.m_110185_();
            ++this.renderTypes;
            for (BufferSegment segment : typeToSegment.getOrDefault(type2, Collections.emptyList())) {
                this.segmentRenderer.drawInner(segment);
                ++this.drawCalls;
            }
            type2.m_110188_();
        }
        profiler.m_6182_("reset");
        this.renderOrderManager.reset();
        this.affinities.clear();
        profiler.m_7238_();
    }

    public int getDrawCalls() {
        return this.drawCalls;
    }

    public int getRenderTypes() {
        return this.renderTypes;
    }

    public void resetDrawCalls() {
        this.drawCalls = 0;
        this.renderTypes = 0;
    }

    public void m_109912_(RenderType type) {
    }

    public MultiBufferSource.BufferSource getUnflushableWrapper() {
        return this.unflushableWrapper;
    }

    @Override
    public int getAllocatedSize() {
        int size = 0;
        for (SegmentedBufferBuilder builder : this.builders) {
            size += builder.getAllocatedSize();
        }
        return size;
    }

    @Override
    public int getUsedSize() {
        int size = 0;
        for (SegmentedBufferBuilder builder : this.builders) {
            size += builder.getUsedSize();
        }
        return size;
    }

    @Override
    public void freeAndDeleteBuffer() {
        for (SegmentedBufferBuilder builder : this.builders) {
            builder.freeAndDeleteBuffer();
        }
    }

    @Override
    public void startGroup() {
        this.renderOrderManager.startGroup();
    }

    @Override
    public boolean maybeStartGroup() {
        return this.renderOrderManager.maybeStartGroup();
    }

    @Override
    public void endGroup() {
        this.renderOrderManager.endGroup();
    }

    @Override
    public void pushWrappingFunction(Function<RenderType, RenderType> wrappingFunction) {
        if (this.wrappingFunction != null) {
            this.wrappingFunctionStack.add(this.wrappingFunction);
        }
        this.wrappingFunction = wrappingFunction;
    }

    @Override
    public void popWrappingFunction() {
        this.wrappingFunction = this.wrappingFunctionStack.isEmpty() ? null : this.wrappingFunctionStack.remove(this.wrappingFunctionStack.size() - 1);
    }

    @Override
    public void assertWrapStackEmpty() {
        if (!this.wrappingFunctionStack.isEmpty() || this.wrappingFunction != null) {
            throw new IllegalStateException("Wrapping function stack not empty!");
        }
    }

    private static class UnflushableWrapper
    extends MultiBufferSource.BufferSource
    implements Groupable {
        private final FullyBufferedMultiBufferSource wrapped;

        UnflushableWrapper(FullyBufferedMultiBufferSource wrapped) {
            super(new BufferBuilder(0), Collections.emptyMap());
            this.wrapped = wrapped;
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            return this.wrapped.m_6299_(renderType);
        }

        public void m_109911_() {
        }

        public void m_109912_(RenderType type) {
        }

        @Override
        public void startGroup() {
            this.wrapped.startGroup();
        }

        @Override
        public boolean maybeStartGroup() {
            return this.wrapped.maybeStartGroup();
        }

        @Override
        public void endGroup() {
            this.wrapped.endGroup();
        }
    }
}

