/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.shader_overrides;

import com.mojang.blaze3d.systems.RenderSystem;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderParser;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.render.chunk.ShaderChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexType;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkProgramOverrides;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkShaderInterface;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ShaderChunkRendererExt;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderChunkRenderer.class})
public class MixinShaderChunkRenderer
implements ShaderChunkRendererExt {
    @Unique
    private IrisChunkProgramOverrides irisChunkProgramOverrides;
    @Unique
    private GlProgram<IrisChunkShaderInterface> override;
    @Shadow(remap=false)
    private GlProgram<ChunkShaderInterface> activeProgram;
    @Shadow(remap=false)
    @Final
    protected ChunkVertexType vertexType;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void iris$onInit(RenderDevice device, ChunkVertexType vertexType, CallbackInfo ci) {
        this.irisChunkProgramOverrides = new IrisChunkProgramOverrides();
    }

    @Redirect(method={"createShader"}, remap=false, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/gl/shader/ShaderLoader;loadShader(Lme/jellysquid/mods/sodium/client/gl/shader/ShaderType;Lnet/minecraft/resources/ResourceLocation;Lme/jellysquid/mods/sodium/client/gl/shader/ShaderConstants;)Lme/jellysquid/mods/sodium/client/gl/shader/GlShader;", ordinal=0, remap=false))
    private GlShader iris$redirectOriginalShader(ShaderType type, ResourceLocation name, ShaderConstants constants) {
        if (this.vertexType == IrisModelVertexFormats.MODEL_VERTEX_XHFP) {
            String shader = ShaderLoader.getShaderSource((ResourceLocation)name);
            shader = shader.replace("v_LightCoord = _vert_tex_light_coord", "v_LightCoord = (iris_LightmapTextureMatrix * vec4(_vert_tex_light_coord, 0, 1)).xy");
            StringTransformations transformations = new StringTransformations(shader);
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 iris_LightmapTextureMatrix = mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0));");
            return new GlShader(type, name, ShaderParser.parseShader((String)transformations.toString(), (ShaderConstants)constants));
        }
        return ShaderLoader.loadShader((ShaderType)type, (ResourceLocation)name, (ShaderConstants)constants);
    }

    @Inject(method={"begin"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void iris$begin(BlockRenderPass pass, CallbackInfo ci) {
        this.override = this.irisChunkProgramOverrides.getProgramOverride(pass, this.vertexType);
        this.irisChunkProgramOverrides.bindFramebuffer(pass);
        if (this.override == null) {
            return;
        }
        ci.cancel();
        this.activeProgram = null;
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            RenderSystem.m_69464_();
        }
        this.override.bind();
        ((IrisChunkShaderInterface)this.override.getInterface()).setup();
    }

    @Inject(method={"end"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void iris$onEnd(CallbackInfo ci) {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        this.irisChunkProgramOverrides.unbindFramebuffer();
        if (this.override != null) {
            ((IrisChunkShaderInterface)this.override.getInterface()).restore();
            this.override.unbind();
            this.override = null;
            ci.cancel();
        }
    }

    @Inject(method={"delete"}, at={@At(value="HEAD")}, remap=false)
    private void iris$onDelete(CallbackInfo ci) {
        this.irisChunkProgramOverrides.deleteShaders();
    }

    @Override
    public GlProgram<IrisChunkShaderInterface> iris$getOverride() {
        return this.override;
    }
}

