/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.vertex_format;

import me.jellysquid.mods.sodium.client.render.vertex.VertexFormatDescription;
import me.jellysquid.mods.sodium.client.render.vertex.transform.CommonVertexElement;
import me.jellysquid.mods.sodium.client.render.vertex.transform.VertexTransform;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisCommonVertexElements;
import net.coderbot.iris.vertices.IrisVertexFormats;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={VertexTransform.class})
public class MixinVertexTransform {
    @Overwrite(remap=false)
    public static void transformSprite(long ptr, int count, VertexFormatDescription format, float minU, float minV, float maxU, float maxV) {
        long stride = format.stride;
        long offsetUV = format.getOffset(CommonVertexElement.TEXTURE);
        boolean hasMidTexCoord = false;
        long offsetMidTexCoord = 0L;
        if (format.getElements().contains(IrisVertexFormats.MID_TEXTURE_ELEMENT)) {
            hasMidTexCoord = true;
            offsetMidTexCoord = format.getOffset(IrisCommonVertexElements.MID_TEX_COORD);
        }
        float w = maxU - minU;
        float h = maxV - minV;
        for (int vertexIndex = 0; vertexIndex < count; ++vertexIndex) {
            float u = MemoryUtil.memGetFloat((long)(ptr + offsetUV + 0L));
            float v = MemoryUtil.memGetFloat((long)(ptr + offsetUV + 4L));
            float ut = minU + w * u;
            float vt = minV + h * v;
            MemoryUtil.memPutFloat((long)(ptr + offsetUV + 0L), (float)ut);
            MemoryUtil.memPutFloat((long)(ptr + offsetUV + 4L), (float)vt);
            if (hasMidTexCoord) {
                float midU = MemoryUtil.memGetFloat((long)(ptr + offsetMidTexCoord + 0L));
                float midV = MemoryUtil.memGetFloat((long)(ptr + offsetMidTexCoord + 4L));
                float midut = minU + w * midU;
                float midvt = minV + h * midV;
                MemoryUtil.memPutFloat((long)(ptr + offsetMidTexCoord + 0L), (float)midut);
                MemoryUtil.memPutFloat((long)(ptr + offsetMidTexCoord + 4L), (float)midvt);
            }
            ptr += stride;
        }
    }
}

