/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import io.github.douira.glsl_transformer.ast.node.Profile;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.VersionStatement;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.index.PrefixIdentifierIndex;
import io.github.douira.glsl_transformer.ast.transform.EnumASTTransformer;
import io.github.douira.glsl_transformer.token_filter.ChannelFilter;
import io.github.douira.glsl_transformer.token_filter.TokenChannel;
import io.github.douira.glsl_transformer.token_filter.TokenFilter;
import io.github.douira.glsl_transformer.util.LRUCache;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;
import net.coderbot.iris.pipeline.transform.parameter.ComputeParameters;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import net.coderbot.iris.pipeline.transform.parameter.SodiumParameters;
import net.coderbot.iris.pipeline.transform.parameter.TextureStageParameters;
import net.coderbot.iris.pipeline.transform.parameter.VanillaParameters;
import net.coderbot.iris.pipeline.transform.transformer.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CommonTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CompatibilityTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CompositeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.SodiumTransformer;
import net.coderbot.iris.pipeline.transform.transformer.TextureTransformer;
import net.coderbot.iris.pipeline.transform.transformer.VanillaTransformer;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import repack.antlr.v4.runtime.RecognitionException;
import repack.antlr.v4.runtime.Token;

public class TransformPatcher {
    static Logger LOGGER = LogManager.getLogger(TransformPatcher.class);
    private static EnumASTTransformer<Parameters, PatchShaderType> transformer;
    private static final boolean useCache = true;
    private static final Map<CacheKey, Map<PatchShaderType, String>> cache;
    static TokenFilter<Parameters> parseTokenFilter;
    private static final List<String> internalPrefixes;
    private static final Pattern versionPattern;

    private static Map<PatchShaderType, String> transform(String vertex, String geometry, String fragment, Parameters parameters) {
        if (vertex == null && geometry == null && fragment == null) {
            return null;
        }
        Map result = null;
        CacheKey key = new CacheKey(parameters, vertex, geometry, fragment);
        if (cache.containsKey(key)) {
            result = cache.get(key);
        }
        if (result == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            inputs.put(PatchShaderType.VERTEX, vertex);
            inputs.put(PatchShaderType.GEOMETRY, geometry);
            inputs.put(PatchShaderType.FRAGMENT, fragment);
            if (parameters instanceof SodiumParameters && ((SodiumParameters)parameters).hasCutoutAlpha()) {
                inputs.put(PatchShaderType.FRAGMENT_CUTOUT, fragment);
            }
            result = transformer.transform(inputs, parameters);
            cache.put(key, result);
        }
        return result;
    }

    private static Map<PatchShaderType, String> transformCompute(String compute, Parameters parameters) {
        if (compute == null) {
            return null;
        }
        Map result = null;
        CacheKey key = new CacheKey(parameters, compute);
        if (cache.containsKey(key)) {
            result = cache.get(key);
        }
        if (result == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            inputs.put(PatchShaderType.COMPUTE, compute);
            result = transformer.transform(inputs, parameters);
            cache.put(key, result);
        }
        return result;
    }

    public static Map<PatchShaderType, String> patchAttributes(String vertex, String geometry, String fragment, InputAvailability inputs, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        return TransformPatcher.transform(vertex, geometry, fragment, new AttributeParameters(Patch.ATTRIBUTES, textureMap, geometry != null, inputs));
    }

    public static Map<PatchShaderType, String> patchVanilla(String vertex, String geometry, String fragment, AlphaTest alpha, boolean hasChunkOffset, ShaderAttributeInputs inputs, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        return TransformPatcher.transform(vertex, geometry, fragment, new VanillaParameters(Patch.VANILLA, textureMap, alpha, hasChunkOffset, inputs, geometry != null));
    }

    public static Map<PatchShaderType, String> patchSodium(String vertex, String geometry, String fragment, AlphaTest cutoutAlpha, AlphaTest defaultAlpha, ShaderAttributeInputs inputs, float positionScale, float positionOffset, float textureScale, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        return TransformPatcher.transform(vertex, geometry, fragment, new SodiumParameters(Patch.SODIUM, textureMap, cutoutAlpha, defaultAlpha, inputs, positionScale, positionOffset, textureScale));
    }

    public static Map<PatchShaderType, String> patchComposite(String vertex, String geometry, String fragment, TextureStage stage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        return TransformPatcher.transform(vertex, geometry, fragment, new TextureStageParameters(Patch.COMPOSITE, stage, textureMap));
    }

    public static String patchCompute(String compute, TextureStage stage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        return TransformPatcher.transformCompute(compute, new ComputeParameters(Patch.COMPUTE, stage, textureMap)).getOrDefault((Object)PatchShaderType.COMPUTE, null);
    }

    static {
        cache = new LRUCache<CacheKey, Map<PatchShaderType, String>>(400);
        parseTokenFilter = new ChannelFilter<Parameters>(TokenChannel.PREPROCESSOR){

            @Override
            public boolean isTokenAllowed(Token token) {
                if (!super.isTokenAllowed(token)) {
                    throw new IllegalArgumentException("Unparsed preprocessor directives such as '" + token.getText() + "' may not be present at this stage of shader processing!");
                }
                return true;
            }
        };
        internalPrefixes = List.of("iris_", "irisMain", "moj_import");
        Root.identifierIndexFactory = PrefixIdentifierIndex::withPrefix;
        transformer = new EnumASTTransformer<Parameters, PatchShaderType>(PatchShaderType.class){

            @Override
            public TranslationUnit parseTranslationUnit(String input) throws RecognitionException {
                Matcher matcher = versionPattern.matcher(input);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("No #version directive found in source code! See debugging.md for more information.");
                }
                Version version = Version.fromNumber(Integer.parseInt(matcher.group(1)));
                if (version.number >= 200) {
                    version = Version.GLSL33;
                }
                TransformPatcher.transformer.getLexer().version = version;
                return super.parseTranslationUnit(input);
            }
        };
        transformer.setTransformation((trees, parameters) -> {
            for (PatchShaderType type : PatchShaderType.values()) {
                TranslationUnit tree = (TranslationUnit)trees.get((Object)type);
                if (tree == null) continue;
                tree.outputOptions.enablePrintInfo();
                parameters.type = type;
                Root root = tree.getRoot();
                internalPrefixes.stream().flatMap(root.getPrefixIdentifierIndex()::prefixQueryFlat).findAny().ifPresent(id -> {
                    throw new IllegalArgumentException("Detected a potential reference to unstable and internal Iris shader interfaces (iris_, irisMain and moj_import). This isn't currently supported. Violation: " + id.getName() + ". See debugging.md for more information.");
                });
                Root.indexBuildSession(tree, () -> {
                    VersionStatement versionStatement = tree.getVersionStatement();
                    if (versionStatement == null) {
                        throw new IllegalStateException("Missing the version statement!");
                    }
                    Profile profile = versionStatement.profile;
                    Version version = versionStatement.version;
                    block0 : switch (parameters.patch) {
                        case ATTRIBUTES: {
                            AttributeTransformer.transform(transformer, tree, root, (AttributeParameters)parameters);
                            break;
                        }
                        case COMPUTE: {
                            versionStatement.profile = Profile.CORE;
                            CommonTransformer.transform(transformer, tree, root, parameters);
                            break;
                        }
                        default: {
                            if (profile == Profile.CORE || version.number >= 150 && profile == null) {
                                if (parameters.type == PatchShaderType.VERTEX) {
                                    throw new IllegalStateException("Vertex shaders with existing core profile found, aborting this part of patching. (Compatibility patches are applied nonetheless) See debugging.md for more information.");
                                }
                                CompatibilityTransformer.transformFragmentCore(transformer, tree, root, parameters);
                                break;
                            }
                            if (version.number >= 330) {
                                if (profile != Profile.COMPATIBILITY) {
                                    throw new IllegalStateException("Expected \"compatibility\" after the GLSL version: #version " + String.valueOf(version) + " " + String.valueOf(profile) + ". See debugging.md for more information.");
                                }
                            } else {
                                versionStatement.version = Version.GLSL33;
                            }
                            versionStatement.profile = Profile.CORE;
                            switch (parameters.patch) {
                                case COMPOSITE: {
                                    CompositeTransformer.transform(transformer, tree, root, parameters);
                                    break block0;
                                }
                                case SODIUM: {
                                    SodiumParameters sodiumParameters = (SodiumParameters)parameters;
                                    sodiumParameters.setAlphaFor(type);
                                    SodiumTransformer.transform(transformer, tree, root, sodiumParameters);
                                    break block0;
                                }
                                case VANILLA: {
                                    VanillaTransformer.transform(transformer, tree, root, (VanillaParameters)parameters);
                                    break block0;
                                }
                            }
                            throw new UnsupportedOperationException("Unknown patch type: " + String.valueOf((Object)parameters.patch));
                        }
                    }
                    TextureTransformer.transform(transformer, tree, root, parameters.getTextureStage(), parameters.getTextureMap());
                    CompatibilityTransformer.transformEach(transformer, tree, root, parameters);
                });
            }
            CompatibilityTransformer.transformGrouped(transformer, trees, parameters);
        });
        transformer.setTokenFilter(parseTokenFilter);
        versionPattern = Pattern.compile("^.*#version\\s+(\\d+)", 32);
    }

    private static class CacheKey {
        final Parameters parameters;
        final String vertex;
        final String geometry;
        final String fragment;
        final String compute;

        public CacheKey(Parameters parameters, String vertex, String geometry, String fragment) {
            this.parameters = parameters;
            this.vertex = vertex;
            this.geometry = geometry;
            this.fragment = fragment;
            this.compute = null;
        }

        public CacheKey(Parameters parameters, String compute) {
            this.parameters = parameters;
            this.vertex = null;
            this.geometry = null;
            this.fragment = null;
            this.compute = compute;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            result = 31 * result + (this.vertex == null ? 0 : this.vertex.hashCode());
            result = 31 * result + (this.geometry == null ? 0 : this.geometry.hashCode());
            result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
            result = 31 * result + (this.compute == null ? 0 : this.compute.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
                return false;
            }
            if (this.vertex == null ? other.vertex != null : !this.vertex.equals(other.vertex)) {
                return false;
            }
            if (this.geometry == null ? other.geometry != null : !this.geometry.equals(other.geometry)) {
                return false;
            }
            if (this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment)) {
                return false;
            }
            return !(this.compute == null ? other.compute != null : !this.compute.equals(other.compute));
        }
    }
}

