/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.rule.resolver;

import java.util.Iterator;
import java.util.List;
import xaero.common.category.FilterObjectCategory;
import xaero.common.category.rule.ExcludeListMode;
import xaero.common.category.rule.ObjectCategoryExcludeList;
import xaero.common.category.rule.ObjectCategoryIncludeList;

public final class ObjectCategoryRuleResolver {
    private ObjectCategoryRuleResolver() {
    }

    public <E, P, C extends FilterObjectCategory<E, P, ?, C>> C resolve(C category, E element, P context) {
        if (this.followsRules(category, element, context)) {
            Iterator subCategoryIterator = category.getDirectSubCategoryIterator();
            while (subCategoryIterator.hasNext()) {
                FilterObjectCategory subCategory = (FilterObjectCategory)subCategoryIterator.next();
                FilterObjectCategory subResolve = this.resolve(subCategory, element, context);
                if (subResolve == null) continue;
                return (C)subResolve;
            }
            return category;
        }
        return null;
    }

    private <E, P, C extends FilterObjectCategory<E, P, ?, C>> boolean followsRules(C category, E element, P context) {
        int i;
        boolean result = category.getBaseRule().isFollowedBy(element, context);
        if (!result) {
            List<ObjectCategoryIncludeList<E, P, ?>> includeLists = category.getIncludeLists();
            for (i = 0; i < includeLists.size(); ++i) {
                ObjectCategoryIncludeList<E, P, ?> includeList = includeLists.get(i);
                if (!includeList.isFollowedBy(element, context)) continue;
                result = true;
                break;
            }
        }
        if (result) {
            List<ObjectCategoryExcludeList<E, P, ?>> excludeLists = category.getExcludeLists();
            if (category.getExcludeMode() == ExcludeListMode.ALL_BUT) {
                result = false;
            }
            for (i = 0; i < excludeLists.size(); ++i) {
                ObjectCategoryExcludeList<E, P, ?> excludeList = excludeLists.get(i);
                if (result == excludeList.isFollowedBy(element, context)) continue;
                result = !result;
                break;
            }
        }
        return result;
    }

    public static final class Builder {
        private Builder() {
        }

        public Builder setDefault() {
            return this;
        }

        public ObjectCategoryRuleResolver build() {
            return new ObjectCategoryRuleResolver();
        }

        public static Builder getDefault() {
            return new Builder().setDefault();
        }
    }
}

