/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.element.render.map;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementReader;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.element.render.MinimapElementRendererHandler;
import xaero.common.minimap.render.MinimapRendererHelper;

public final class MinimapElementMapRendererHandler
extends MinimapElementRendererHandler {
    private float halfWView;

    protected MinimapElementMapRendererHandler(List<MinimapElementRenderer<?, ?>> renderers) {
        super(renderers, 0);
    }

    public void render(PoseStack matrixStack, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, double playerDimDiv, double ps, double pc, double zoom, boolean cave, float partialTicks, RenderTarget framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, MultiBufferSource.BufferSource renderTypeBuffers, Font font, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers, float halfWView) {
        this.halfWView = halfWView;
        super.render(matrixStack, renderEntity, player, renderX, renderY, renderZ, playerDimDiv, ps, pc, zoom, cave, partialTicks, framebuffer, modMain, helper, renderTypeBuffers, font, multiTextureRenderTypeRenderers);
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(RR renderer, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, Font font, RenderTarget framebuffer, MinimapRendererHelper helper, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, double playerDimDiv, double ps, double pc, double zoom, boolean cave, float partialTicks, int elementIndex, double optionalDepth, E element, MinimapElementReader<E, RRC> elementReader, RRC context) {
        double offx = elementReader.getRenderX(element, context, partialTicks) / playerDimDiv - renderX;
        double offz = elementReader.getRenderZ(element, context, partialTicks) / playerDimDiv - renderZ;
        matrixStack.m_85836_();
        double zoomedOffX = offx * zoom;
        double zoomedOffZ = offz * zoom;
        double translateX = ps * zoomedOffX - pc * zoomedOffZ;
        double translateY = pc * zoomedOffX + ps * zoomedOffZ;
        int roundedX = (int)Math.round(translateX);
        int roundedY = (int)Math.round(translateY);
        boolean outOfBounds = (float)Math.abs(roundedX) > this.halfWView || Math.abs(renderY) > (double)this.halfWView;
        double partialX = translateX - (double)roundedX;
        double partialY = translateY - (double)roundedY;
        matrixStack.m_252880_((float)roundedX, (float)roundedY, 0.0f);
        boolean result = renderer.renderElement(this.location, false, outOfBounds, matrixStack, renderTypeBuffers, font, framebuffer, helper, renderEntity, player, renderX, renderY, renderZ, elementIndex, optionalDepth, 1.0f, element, partialX, partialY, cave, partialTicks);
        matrixStack.m_85849_();
        return result;
    }

    @Override
    protected int getIndexLimit() {
        return 19490;
    }

    @Override
    protected void beforeRender(PoseStack matrixStack) {
    }

    @Override
    protected void afterRender(PoseStack matrixStack) {
    }

    public static final class Builder
    extends MinimapElementRendererHandler.Builder {
        @Override
        public MinimapElementMapRendererHandler build() {
            return (MinimapElementMapRendererHandler)super.build();
        }

        @Override
        protected MinimapElementMapRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> renderers) {
            return new MinimapElementMapRendererHandler(renderers);
        }

        @Override
        protected Builder setDefault() {
            super.setDefault();
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

