/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.graphics.shader.PositionTexAlphaTestShader;
import xaero.common.misc.Misc;

public class MinimapRendererHelper {
    private static BlendMode defaultShaderDisabledBlendState = new BlendMode();
    private static BlendMode defaultShaderBlendState = new BlendMode(770, 771, 32774);

    public void drawMyTexturedModalRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        this.drawMyTexturedModalRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f, true);
    }

    public void drawMyTexturedModalRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha, boolean blend) {
        if (discardAlpha < 0.0f) {
            RenderSystem.m_157427_(blend ? () -> MinimapShaders.POSITION_TEX_NO_ALPHA_TEST : () -> MinimapShaders.POSITION_TEX_NO_ALPHA_TEST_NO_BLEND);
        } else {
            RenderSystem.m_157427_(blend ? () -> MinimapShaders.POSITION_TEX_ALPHA_TEST : () -> MinimapShaders.POSITION_TEX_ALPHA_TEST_NO_BLEND);
            ((PositionTexAlphaTestShader)RenderSystem.m_157196_()).setDiscardAlpha(discardAlpha);
        }
        this.drawMyTexturedModalRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }

    public void drawIconOutline(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        MinimapShaders.POSITION_TEX_ICON_OUTLINE.setDiscardAlpha(discardAlpha);
        RenderSystem.m_157427_(() -> MinimapShaders.POSITION_TEX_ICON_OUTLINE);
        this.drawMyTexturedModalRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }

    private void drawMyTexturedModalRectInternal(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexBuffer.m_252986_(matrix, x + 0.0f, y + height, 0.0f).m_7421_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(((float)textureX + width) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + width, y + 0.0f, 0.0f).m_7421_(((float)textureX + width) * f, ((float)textureY + theight) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + 0.0f, y + 0.0f, 0.0f).m_7421_((float)(textureX + 0) * f, ((float)textureY + theight) * f1).m_5752_();
        tessellator.m_85914_();
    }

    public void prepareMyTexturedColoredModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, float r, float g, float b, float a, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        BufferBuilder vertexBuffer = renderer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, textureId);
        vertexBuffer.m_252986_(matrix, x + 0.0f, y + height, 0.0f).m_85950_(r, g, b, a).m_7421_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + width, y + height, 0.0f).m_85950_(r, g, b, a).m_7421_(((float)textureX + width) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + width, y + 0.0f, 0.0f).m_85950_(r, g, b, a).m_7421_(((float)textureX + width) * f, ((float)textureY + theight) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + 0.0f, y + 0.0f, 0.0f).m_85950_(r, g, b, a).m_7421_((float)(textureX + 0) * f, ((float)textureY + theight) * f1).m_5752_();
    }

    public void prepareMyTexturedModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        BufferBuilder vertexBuffer = renderer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_, textureId);
        vertexBuffer.m_252986_(matrix, x + 0.0f, y + height, 0.0f).m_7421_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(((float)textureX + width) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + width, y + 0.0f, 0.0f).m_7421_(((float)textureX + width) * f, ((float)textureY + theight) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + 0.0f, y + 0.0f, 0.0f).m_7421_((float)(textureX + 0) * f, ((float)textureY + theight) * f1).m_5752_();
    }

    void drawTexturedElipseInsideRectangle(PoseStack matrixStack, double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float widthFactor) {
        this.drawTexturedElipseInsideRectangle(matrixStack, startAngle, sides, x, y, textureX, textureY, width, width, widthFactor);
    }

    void drawTexturedElipseInsideRectangle(PoseStack matrixStack, double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        float halfWidth = width / 2.0f;
        double centerX = x + halfWidth;
        double centerY = y + halfWidth;
        float centerU = ((float)textureX + halfWidth) * f;
        float centerV = (float)(((double)textureY + (double)theight * 0.5) * (double)f1);
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalV = 0.0f;
        vertexBuffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
        for (int i = 0; i <= sides; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalV = (float)((double)theight * (1.0 - 0.5 * (1.0 - cos)));
            if (i > 0) {
                vertexBuffer.m_252986_(matrix, x + vertexLocalX, y + vertexLocalY, 0.0f).m_7421_(((float)textureX + vertexLocalX) * f, ((float)textureY + vertexLocalV) * f1).m_5752_();
                vertexBuffer.m_252986_(matrix, x + prevVertexLocalX, y + prevVertexLocalY, 0.0f).m_7421_(((float)textureX + prevVertexLocalX) * f, ((float)textureY + prevVertexLocalV) * f1).m_5752_();
                vertexBuffer.m_252986_(matrix, (float)centerX, (float)centerY, 0.0f).m_7421_(centerU, centerV).m_5752_();
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalV = vertexLocalV;
        }
        tessellator.m_85914_();
    }

    void drawTexturedElipseInsideRectangleFrame(PoseStack matrixStack, boolean resetTexture, boolean reverseTexture, double startAngle, int startIndex, int endIndex, int sides, float thickness, float x, float y, int textureX, int textureY, float width, float twidth, float theight, int seamWidth, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        float halfWidth = width / 2.0f;
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalOuterX = 0.0f;
        float prevVertexLocalOuterY = 0.0f;
        float prevSegmentTextureX = 0.0f;
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float outerRadius = halfWidth + thickness;
        float segmentOuterWidth = (float)(fullCircle / (double)sides * (double)outerRadius);
        startIndex = Math.max(Math.min(startIndex, sides), 0);
        endIndex = Math.max(Math.min(endIndex, sides), startIndex);
        int textureStartIndex = resetTexture ? (reverseTexture ? endIndex : startIndex) : 0;
        float seamThreshold = reverseTexture ? (float)seamWidth + segmentOuterWidth : (float)seamWidth;
        for (int i = startIndex; i <= endIndex; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalOuterX = halfWidth + (float)((double)outerRadius * sin);
            float vertexLocalOuterY = (float)((double)halfWidth - (double)outerRadius * cos);
            float segmentTextureStartX = textureX;
            float offsetX = Math.abs(segmentOuterWidth * (float)(i - textureStartIndex));
            if (offsetX >= seamThreshold) {
                segmentTextureStartX = textureX + seamWidth;
                if ((offsetX -= seamThreshold) >= twidth) {
                    offsetX %= twidth;
                }
            }
            float segmentTextureX = segmentTextureStartX + offsetX;
            if (i > startIndex) {
                vertexBuffer.m_252986_(matrix, x + prevVertexLocalX, y + prevVertexLocalY, 0.0f).m_7421_(prevSegmentTextureX * f, ((float)textureY + theight) * f1).m_5752_();
                vertexBuffer.m_252986_(matrix, x + vertexLocalX, y + vertexLocalY, 0.0f).m_7421_(segmentTextureX * f, ((float)textureY + theight) * f1).m_5752_();
                vertexBuffer.m_252986_(matrix, x + vertexLocalOuterX, y + vertexLocalOuterY, 0.0f).m_7421_(segmentTextureX * f, (float)textureY * f1).m_5752_();
                vertexBuffer.m_252986_(matrix, x + prevVertexLocalOuterX, y + prevVertexLocalOuterY, 0.0f).m_7421_(prevSegmentTextureX * f, (float)textureY * f1).m_5752_();
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalOuterX = vertexLocalOuterX;
            prevVertexLocalOuterY = vertexLocalOuterY;
            prevSegmentTextureX = segmentTextureX;
        }
        tessellator.m_85914_();
    }

    public void addTexturedRectToExistingBuffer(Matrix4f matrix, VertexConsumer vertexBuffer, float x, float y, int u, int v, int w, int h) {
        float f = 0.00390625f;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + w) * f;
        float normalizedV2 = (float)(v + h) * f;
        vertexBuffer.m_252986_(matrix, x, y + (float)h, 0.0f).m_7421_(normalizedU1, normalizedV2).m_5752_();
        vertexBuffer.m_252986_(matrix, x + (float)w, y + (float)h, 0.0f).m_7421_(normalizedU2, normalizedV2).m_5752_();
        vertexBuffer.m_252986_(matrix, x + (float)w, y, 0.0f).m_7421_(normalizedU2, normalizedV1).m_5752_();
        vertexBuffer.m_252986_(matrix, x, y, 0.0f).m_7421_(normalizedU1, normalizedV1).m_5752_();
    }

    public void addTexturedColoredRectToExistingBuffer(Matrix4f matrix, VertexConsumer vertexBuffer, float x, float y, int u, int v, int w, int h, float r, float g, float b, float a, float factor) {
        this.addTexturedColoredRectToExistingBuffer(matrix, vertexBuffer, x, y, u, v, w, h, w, h, r, g, b, a, factor);
    }

    public void addTexturedColoredRectToExistingBuffer(Matrix4f matrix, VertexConsumer vertexBuffer, float x, float y, int u, int v, int w, int h, int tw, int th, float r, float g, float b, float a, float factor) {
        float f = 1.0f / factor;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + tw) * f;
        float normalizedV2 = (float)(v + th) * f;
        vertexBuffer.m_252986_(matrix, x, y + (float)h, 0.0f).m_85950_(r, g, b, a).m_7421_(normalizedU1, normalizedV1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + (float)w, y + (float)h, 0.0f).m_85950_(r, g, b, a).m_7421_(normalizedU2, normalizedV1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + (float)w, y, 0.0f).m_85950_(r, g, b, a).m_7421_(normalizedU2, normalizedV2).m_5752_();
        vertexBuffer.m_252986_(matrix, x, y, 0.0f).m_85950_(r, g, b, a).m_7421_(normalizedU1, normalizedV2).m_5752_();
    }

    public void addColoredRectToExistingBuffer(Matrix4f matrix, VertexConsumer vertexBuffer, float x, float y, int w, int h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.addColoredRectToExistingBuffer(matrix, vertexBuffer, x, y, w, h, r, g, b, a);
    }

    public void addColoredRectToExistingBuffer(Matrix4f matrix, VertexConsumer vertexBuffer, float x, float y, int w, int h, float r, float g, float b, float a) {
        vertexBuffer.m_252986_(matrix, x, y + (float)h, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x + (float)w, y + (float)h, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x + (float)w, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    public void drawMyColoredRect(PoseStack matrixStack, float x1, float y1, float x2, float y2) {
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        vertexBuffer.m_252986_(matrix, x1, y2, 0.0f).m_5752_();
        vertexBuffer.m_252986_(matrix, x2, y2, 0.0f).m_5752_();
        vertexBuffer.m_252986_(matrix, x2, y1, 0.0f).m_5752_();
        vertexBuffer.m_252986_(matrix, x1, y1, 0.0f).m_5752_();
        tessellator.m_85914_();
    }

    public void addColoredLineToExistingBuffer(PoseStack.Pose matrices, VertexConsumer vertexBuffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        vertexBuffer.m_252986_(matrices.m_252922_(), x1, y1, 0.0f).m_85950_(r, g, b, a).m_252939_(matrices.m_252943_(), x2 - x1, y2 - y1, 0.0f).m_5752_();
        vertexBuffer.m_252986_(matrices.m_252922_(), x2, y2, 0.0f).m_85950_(r, g, b, a).m_252939_(matrices.m_252943_(), x2 - x1, y2 - y1, 0.0f).m_5752_();
    }

    public void drawMyColoredRect(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vertexBuffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        tessellator.m_85914_();
    }

    void bindTextureBuffer(ByteBuffer image, int width, int height, int par0) {
        GlStateManager.m_84544_((int)par0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)image);
        RenderSystem.m_157453_((int)0, (int)par0);
    }

    void putColor(byte[] bytes, int x, int y, int red, int green, int blue, int size) {
        int pixel = (y * size + x) * 3;
        bytes[pixel] = (byte)red;
        bytes[++pixel] = (byte)green;
        bytes[++pixel] = (byte)blue;
    }

    void gridOverlay(int[] result, int grid, int red, int green, int blue) {
        result[0] = (red * 3 + (grid >> 16 & 0xFF)) / 4;
        result[1] = (green * 3 + (grid >> 8 & 0xFF)) / 4;
        result[2] = (blue * 3 + (grid & 0xFF)) / 4;
    }

    void slimeOverlay(int[] result, int red, int green, int blue) {
        result[0] = (red + 82) / 2;
        result[1] = (green + 241) / 2;
        result[2] = (blue + 64) / 2;
    }

    public void defaultOrtho(RenderTarget framebuffer, boolean raw) {
        if (framebuffer != null) {
            Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)framebuffer.f_83915_, (float)framebuffer.f_83916_, 0.0f, 1000.0f, 3000.0f);
            RenderSystem.m_252934_((Matrix4f)ortho);
        } else {
            Misc.minecraftOrtho(Minecraft.m_91087_(), raw);
        }
    }

    public static void restoreDefaultShaderBlendState() {
        defaultShaderDisabledBlendState.m_85526_();
        defaultShaderBlendState.m_85526_();
        RenderSystem.m_69453_();
    }
}

