/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.chiseling;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.LocalStrings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public interface IChiselingContext
extends IStateAccessor {
    @NotNull
    public Optional<IWorldAreaMutator> getMutator();

    @NotNull
    public LevelAccessor getWorld();

    @NotNull
    public IChiselMode getMode();

    @NotNull
    public IChiselingContext include(Vec3 var1);

    @NotNull
    default public IChiselingContext include(BlockPos inWorldPosition, Vec3 relativeInBlockPosition) {
        return this.include(Vec3.m_82528_((Vec3i)inWorldPosition).m_82549_(relativeInBlockPosition));
    }

    public void setComplete();

    public boolean isComplete();

    public boolean isSimulation();

    @NotNull
    public ChiselingOperation getModeOfOperandus();

    @NotNull
    public IChiselingContext createSnapshot();

    default public boolean tryDamageItem() {
        return this.tryDamageItem(1);
    }

    default public boolean tryDamageItem(int damage) {
        return this.tryDamageItemAndDo(damage, () -> {}, () -> {}) > 0;
    }

    default public int tryDamageItemAndDo(Runnable onDamaged, Runnable onBroken) {
        return this.tryDamageItemAndDo(1, onDamaged, onBroken);
    }

    default public int tryDamageItemAndDoOrSetBrokenError(Runnable onDamaged) {
        return this.tryDamageItemAndDo(1, onDamaged, () -> this.setError(LocalStrings.ChiselAttemptFailedChiselBroke.getText()));
    }

    default public int tryDamageItemAndDo(int damage, Runnable onDamaged) {
        return this.tryDamageItemAndDo(damage, onDamaged, () -> this.setError(LocalStrings.ChiselAttemptFailedChiselBroke.getText()));
    }

    public int tryDamageItemAndDo(int var1, Runnable var2, Runnable var3);

    public void setStateFilter(@NotNull Function<IAreaAccessor, Predicate<IStateEntryInfo>> var1);

    public void clearStateFilter();

    public Optional<Function<IAreaAccessor, Predicate<IStateEntryInfo>>> getStateFilter();

    public <T> Optional<T> getMetadata(IMetadataKey<T> var1);

    public void removeMetadata(IMetadataKey<?> var1);

    public <T> void setMetadata(IMetadataKey<T> var1, T var2);

    public void resetMutator();

    public void setError(MutableComponent var1);

    public Optional<MutableComponent> getError();
}

