/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.network.packets.ModPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class RequestChangeTrackerOperationPacket
extends ModPacket {
    private boolean redo;

    public RequestChangeTrackerOperationPacket(FriendlyByteBuf byteBuf) {
        this.readPayload(byteBuf);
    }

    public RequestChangeTrackerOperationPacket(boolean redo) {
        this.redo = redo;
    }

    @Override
    public void writePayload(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.redo);
    }

    @Override
    public void readPayload(FriendlyByteBuf buffer) {
        this.redo = buffer.readBoolean();
    }

    @Override
    public void server(ServerPlayer playerEntity) {
        IChangeTracker tracker = IChangeTrackerManager.getInstance().getChangeTracker((Player)playerEntity);
        if (this.redo) {
            if (!tracker.canRedo((Player)playerEntity)) {
                playerEntity.m_213846_((Component)LocalStrings.CanNotRedo.getText().m_130940_(ChatFormatting.RED));
                return;
            }
            try {
                tracker.redo((Player)playerEntity);
                playerEntity.m_213846_((Component)LocalStrings.RedoSuccessful.getText().m_130940_(ChatFormatting.GREEN));
            }
            catch (IllegalChangeAttempt e) {
                playerEntity.m_213846_((Component)LocalStrings.CanNotRedo.getText().m_130940_(ChatFormatting.RED));
            }
            return;
        }
        if (!tracker.canUndo((Player)playerEntity)) {
            playerEntity.m_213846_((Component)LocalStrings.CanNotUndo.getText().m_130940_(ChatFormatting.RED));
            return;
        }
        try {
            tracker.undo((Player)playerEntity);
            playerEntity.m_213846_((Component)LocalStrings.UndoSuccessful.getText().m_130940_(ChatFormatting.GREEN));
        }
        catch (IllegalChangeAttempt e) {
            playerEntity.m_213846_((Component)LocalStrings.CanNotUndo.getText().m_130940_(ChatFormatting.RED));
        }
    }
}

