/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.storage;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.chiselsandbits.storage.IStorageHandler;
import mod.chiselsandbits.storage.IThreadAwareStorageEngine;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

final class VersionedStorageEngine
implements IThreadAwareStorageEngine {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int minimalVersion;
    private final List<IStorageHandler<?>> handlers;
    private final int currentVersion;
    private final IStorageHandler<?> saveHandler;

    VersionedStorageEngine(LinkedList<IStorageHandler<?>> handlers) {
        this(0, handlers);
    }

    VersionedStorageEngine(int minimalVersion, LinkedList<IStorageHandler<?>> handlers) {
        Validate.notEmpty(handlers);
        this.minimalVersion = minimalVersion;
        this.handlers = Collections.unmodifiableList(handlers);
        this.saveHandler = handlers.getLast();
        this.currentVersion = minimalVersion + handlers.size() - 1;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        this.serializeNBTInto(compoundTag);
        return compoundTag;
    }

    @Override
    public void serializeNBTInto(CompoundTag tag) {
        tag.m_128405_("version", this.currentVersion);
        tag.m_128365_("data", this.saveHandler.serializeNBT());
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag nbt) {
        IStorageHandler<?> storageHandler = this.readStorageHandler(nbt);
        if (storageHandler == null) {
            return;
        }
        storageHandler.deserializeNBT(nbt.m_128469_("data"));
    }

    @Nullable
    private IStorageHandler<?> readStorageHandler(@NotNull CompoundTag nbt) {
        int version;
        if (nbt.m_128456_()) {
            LOGGER.warn("Empty NBT tag received, ignoring.");
            return null;
        }
        if (!nbt.m_128441_("version")) {
            LOGGER.warn("The given NBT did not contain a versioned storage data entry. Missing the version!");
        }
        int n = version = nbt.m_128441_("version") ? nbt.m_128451_("version") : this.minimalVersion;
        if (version < this.minimalVersion) {
            throw new IllegalArgumentException("The given NBT did contained a version storage data entry, which is of an unsupported version. The version is " + version + ", but the minimal version is " + this.minimalVersion);
        }
        if (version > this.currentVersion) {
            throw new IllegalArgumentException("The given NBT did contained a version storage data entry, which is of an unsupported version. The version is " + version + ", but the current version is " + this.currentVersion);
        }
        int index = version - this.minimalVersion;
        return this.handlers.get(index);
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(this.serializeNBT());
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        this.deserializeNBT(Objects.requireNonNull(packetBuffer.m_130261_()));
    }

    @Override
    public Collection<? extends IStorageHandler<?>> getHandlers() {
        return this.handlers;
    }

    @Override
    public CompletableFuture<Void> deserializeOffThread(CompoundTag tag, Executor ioExecutor, Executor gameExecutor) {
        IStorageHandler<?> storageHandler = this.readStorageHandler(tag);
        if (storageHandler == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.doDeserializeOffThread(storageHandler, tag, ioExecutor, gameExecutor);
    }

    private <P> CompletableFuture<Void> doDeserializeOffThread(IStorageHandler<P> handler, CompoundTag tag, Executor ioExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> handler.readPayloadOffThread(tag.m_128469_("data")), ioExecutor).thenAcceptAsync(handler::syncPayloadOnGameThread, gameExecutor);
    }
}

