/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkSectionUtils {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.m_238371_((IdMap)Block.f_49791_, (Codec)BlockState.f_61039_, (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188137_, (Object)Blocks.f_50016_.m_49966_());
    private static final Logger LOGGER = LogManager.getLogger();

    private ChunkSectionUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ChunkSectionUtils. This is a utility class");
    }

    public static Tag serializeNBT(LevelChunkSection chunkSection) {
        return (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)chunkSection.m_63019_()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    public static CompoundTag serializeNBTCompressed(LevelChunkSection chunkSection) {
        Tag outputTag = (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)chunkSection.m_63019_()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
        if (!(outputTag instanceof CompoundTag)) {
            throw new IllegalStateException("Serialized into incompatible tag type: " + outputTag.m_6458_().m_5986_());
        }
        CompoundTag compressedSectionData = (CompoundTag)outputTag;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            NbtIo.m_128947_((CompoundTag)compressedSectionData, (OutputStream)outputStream);
            byte[] compressedData = outputStream.toByteArray();
            CompoundTag gzipCompressedTag = new CompoundTag();
            gzipCompressedTag.m_128379_("isCompressed", true);
            gzipCompressedTag.m_128382_("compressedData", compressedData);
            return gzipCompressedTag;
        }
        catch (Exception e) {
            LOGGER.error("Failed to compress chiseled block data.", (Throwable)e);
            return compressedSectionData;
        }
    }

    public static void deserializeNBT(LevelChunkSection chunkSection, Tag tag) {
        if (!(tag instanceof CompoundTag)) {
            return;
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        if (compoundTag.m_128456_()) {
            return;
        }
        if (compoundTag.m_128425_("isCompressed", 1) && compoundTag.m_128471_("isCompressed") && compoundTag.m_128425_("compressedData", 7)) {
            try {
                byte[] compressedData = compoundTag.m_128463_("compressedData");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(compressedData);
                CompoundTag decompressedCompoundTag = NbtIo.m_128939_((InputStream)inputStream);
                chunkSection.f_62972_ = (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)decompressedCompoundTag).promotePartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                chunkSection.m_63018_();
                return;
            }
            catch (Exception e) {
                LOGGER.error("Failed to decompress chiseled block entity data. Resetting data.");
                ChunkSectionUtils.fillFromBottom(chunkSection, Blocks.f_50016_.m_49966_(), StateEntrySize.current().getBitsPerBlock());
                chunkSection.m_63018_();
                return;
            }
        }
        chunkSection.f_62972_ = (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag).promotePartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
        chunkSection.m_63018_();
    }

    public static LevelChunkSection rotate90Degrees(LevelChunkSection source, Direction.Axis axis, int rotationCount) {
        if (rotationCount == 0) {
            return source;
        }
        Vec3 centerVector = new Vec3(7.5, 7.5, 7.5);
        LevelChunkSection target = new LevelChunkSection(0, source.m_63019_(), source.m_187996_());
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Vec3 workingVector = new Vec3((double)x, (double)y, (double)z);
                    Vec3 rotatedVector = workingVector.m_82546_(centerVector);
                    for (int i = 0; i < rotationCount; ++i) {
                        rotatedVector = VectorUtils.rotate90Degrees(rotatedVector, axis);
                    }
                    BlockPos sourcePos = VectorUtils.toBlockPos(workingVector);
                    Vec3 offsetPos = rotatedVector.m_82549_(centerVector).m_82542_(1000.0, 1000.0, 1000.0);
                    BlockPos targetPos = VectorUtils.toBlockPos(new Vec3((double)Math.round(offsetPos.m_7096_()), (double)Math.round(offsetPos.m_7098_()), (double)Math.round(offsetPos.m_7094_())).m_82542_(0.001, 0.001, 0.001));
                    target.m_62986_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), source.m_62982_(sourcePos.m_123341_(), sourcePos.m_123342_(), sourcePos.m_123343_()));
                }
            }
        }
        return target;
    }

    public static LevelChunkSection cloneSection(LevelChunkSection lazyChunkSection) {
        LevelChunkSection clone = new LevelChunkSection(0, lazyChunkSection.m_63019_(), lazyChunkSection.m_187996_());
        ChunkSectionUtils.deserializeNBT(clone, ChunkSectionUtils.serializeNBT(lazyChunkSection));
        return clone;
    }

    public static void fillFromBottom(LevelChunkSection chunkSection, BlockState blockState, int amount) {
        int loopCount = Math.max(0, Math.min(amount, StateEntrySize.current().getBitsPerBlock()));
        if (loopCount == 0) {
            return;
        }
        int count = 0;
        for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
            for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
                for (int z = 0; z < StateEntrySize.current().getBitsPerBlockSide(); ++z) {
                    chunkSection.m_62986_(x, y, z, blockState);
                    if (++count != loopCount) continue;
                    return;
                }
            }
        }
    }

    public static LevelChunkSection mirror(LevelChunkSection lazyChunkSection, Direction.Axis axis) {
        LevelChunkSection result = new LevelChunkSection(0, lazyChunkSection.m_63019_(), lazyChunkSection.m_187996_());
        for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
            for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
                for (int z = 0; z < StateEntrySize.current().getBitsPerBlockSide(); ++z) {
                    BlockState blockState = lazyChunkSection.m_62982_(x, y, z);
                    int mirroredX = axis == Direction.Axis.X ? StateEntrySize.current().getBitsPerBlockSide() - x - 1 : x;
                    int mirroredY = axis == Direction.Axis.Y ? StateEntrySize.current().getBitsPerBlockSide() - y - 1 : y;
                    int mirroredZ = axis == Direction.Axis.Z ? StateEntrySize.current().getBitsPerBlockSide() - z - 1 : z;
                    result.m_62991_(mirroredX, mirroredY, mirroredZ, blockState, false);
                }
            }
        }
        return result;
    }
}

