/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import org.joml.Matrix4f;

public class TextUtil {
    private static final FormattedCharSequence CURSOR_MARKER = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_);

    public static Pair<List<FormattedCharSequence>, Float> fitLinesToBox(Font font, FormattedText text, float width, float height) {
        int scalingFactor;
        List splitLines;
        float maxLines;
        int fontWidth = font.m_92852_(text);
        do {
            scalingFactor = Mth.m_14143_((float)Mth.m_14116_((float)((float)fontWidth * 8.0f / (width * height))));
            splitLines = font.m_92923_(text, Mth.m_14143_((float)(width * (float)scalingFactor)));
            maxLines = height * (float)scalingFactor / 8.0f;
            ++fontWidth;
        } while (maxLines < (float)splitLines.size());
        return Pair.of((Object)splitLines, (Object)Float.valueOf(1.0f / (float)scalingFactor));
    }

    public static FormattedText parseText(String s) {
        try {
            MutableComponent mutableComponent = Component.Serializer.m_130701_((String)s);
            if (mutableComponent != null) {
                return mutableComponent;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FormattedText.m_130775_((String)s);
    }

    public static void renderGuiLine(RenderTextProperties properties, String string, Font font, PoseStack poseStack, MultiBufferSource.BufferSource buffer, int cursorPos, int selectionPos, boolean isSelected, boolean blink, int yOffset) {
        poseStack.m_85836_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        if (string != null) {
            if (font.m_92718_()) {
                string = font.m_92801_(string);
            }
            FormattedCharSequence charSequence = FormattedCharSequence.m_13714_((String)string, (Style)properties.style);
            float centerX = (float)(-font.m_92724_(charSequence)) / 2.0f;
            TextUtil.renderLineInternal(charSequence, font, centerX, yOffset, matrix4f, (MultiBufferSource)buffer, properties);
            String substring = string.substring(0, Math.min(cursorPos, string.length()));
            if (isSelected) {
                int pX = (int)((float)font.m_92724_(FormattedCharSequence.m_13714_((String)substring, (Style)properties.style)) + centerX);
                if (blink) {
                    if (cursorPos >= string.length()) {
                        TextUtil.renderLineInternal(CURSOR_MARKER, font, pX, yOffset, matrix4f, (MultiBufferSource)buffer, properties);
                    }
                    buffer.m_109911_();
                }
                if (blink && cursorPos < string.length()) {
                    GuiComponent.m_93172_((PoseStack)poseStack, (int)pX, (int)(yOffset - 1), (int)(pX + 1), (int)(yOffset + 9), (int)(0xFF000000 | properties.textColor));
                }
                if (selectionPos != cursorPos) {
                    int l3 = Math.min(cursorPos, selectionPos);
                    int l1 = Math.max(cursorPos, selectionPos);
                    int i2 = font.m_92895_(string.substring(0, l3)) - font.m_92895_(string) / 2;
                    int j2 = font.m_92895_(string.substring(0, l1)) - font.m_92895_(string) / 2;
                    int startX = Math.min(i2, j2);
                    int startY = Math.max(i2, j2);
                    RenderSystem.m_69479_();
                    RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
                    Gui.m_93172_((PoseStack)poseStack, (int)startX, (int)startY, (int)yOffset, (int)(yOffset + 9), (int)-16776961);
                    RenderSystem.m_69462_();
                }
            }
            if (!isSelected || !blink) {
                buffer.m_109911_();
            }
        }
    }

    public static void renderGuiText(RenderTextProperties properties, String[] guiLines, Font font, PoseStack poseStack, MultiBufferSource.BufferSource buffer, int cursorPos, int selectionPos, int currentLine, boolean blink, int lineSpacing) {
        int nOfLines = guiLines.length;
        for (int line = 0; line < nOfLines; ++line) {
            int yOffset = line * lineSpacing - nOfLines * 5;
            TextUtil.renderGuiLine(properties, guiLines[line], font, poseStack, buffer, cursorPos, selectionPos, line == currentLine, blink, yOffset);
        }
    }

    public static void renderLine(FormattedCharSequence formattedCharSequences, Font font, float yOffset, PoseStack poseStack, MultiBufferSource buffer, RenderTextProperties properties) {
        if (formattedCharSequences == null) {
            return;
        }
        float x = (float)(-font.m_92724_(formattedCharSequences)) / 2.0f;
        TextUtil.renderLineInternal(formattedCharSequences, font, x, yOffset, poseStack.m_85850_().m_252922_(), buffer, properties);
    }

    public static void renderAllLines(FormattedCharSequence[] charSequences, int ySeparation, Font font, PoseStack poseStack, MultiBufferSource buffer, RenderTextProperties properties) {
        for (int i = 0; i < charSequences.length; ++i) {
            TextUtil.renderLine(charSequences[i], font, ySeparation * i, poseStack, buffer, properties);
        }
    }

    private static void renderLineInternal(FormattedCharSequence formattedCharSequences, Font font, float xOffset, float yOffset, Matrix4f matrix4f, MultiBufferSource buffer, RenderTextProperties properties) {
        if (properties.glowing) {
            font.m_168645_(formattedCharSequences, xOffset, yOffset, properties.textColor, properties.darkenedColor, matrix4f, buffer, properties.light);
        } else {
            font.m_272191_(formattedCharSequences, xOffset, yOffset, properties.darkenedColor, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, properties.light);
        }
    }

    private static int getDarkenedColor(int color, boolean glowing) {
        if (color == DyeColor.BLACK.m_41071_() && glowing) {
            return -988212;
        }
        return TextUtil.getDarkenedColor(color, 0.4f);
    }

    private static int getDarkenedColor(int color, float amount) {
        int j = (int)((double)FastColor.ABGR32.m_266313_((int)color) * (double)amount);
        int k = (int)((double)FastColor.ABGR32.m_266446_((int)color) * (double)amount);
        int l = (int)((double)FastColor.ABGR32.m_266247_((int)color) * (double)amount);
        return FastColor.ABGR32.m_266248_((int)0, (int)l, (int)k, (int)j);
    }

    public record RenderTextProperties(int textColor, int darkenedColor, boolean glowing, int light, Style style) {
        public RenderTextProperties(DyeColor color, boolean glowing, int combinedLight, Style style, BooleanSupplier isVeryNear) {
            this(color.m_41071_(), TextUtil.getDarkenedColor(color.m_41071_(), glowing), glowing && (isVeryNear.getAsBoolean() || color == DyeColor.BLACK), glowing ? combinedLight : 0xF000F0, style);
        }
    }
}

