/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration.configured;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.impl.forge.ForgeConfig;
import com.mrcrayfish.configured.impl.forge.ForgeValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.integration.configured.CustomConfigSelectScreen;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.forge.ConfigSpecWrapper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public abstract class CustomConfigScreen
extends ConfigScreen {
    @Nullable
    private static final Field BUTTON_ON_PRESS = CustomConfigScreen.findFieldOrNull(Button.class, "onPress");
    @Nullable
    private static final Field FOLDER_ENTRY = CustomConfigScreen.findFieldOrNull(ConfigScreen.class, "folderEntry");
    @Nullable
    private static final Method SAVE_CONFIG = CustomConfigScreen.findMethodOrNull(ConfigScreen.class, "saveConfig");
    @Nullable
    private static final Field CONFIG_VALUE_HOLDER = CustomConfigScreen.findFieldOrNull(ConfigScreen.ConfigItem.class, "holder");
    @Nullable
    private static final Field BOOLEAN_ITEM_BUTTON = CustomConfigScreen.findFieldOrNull(ConfigScreen.BooleanItem.class, "button");
    protected final String modId;
    protected final Map<String, ItemStack> icons = new HashMap<String, ItemStack>();
    public final ItemStack mainIcon;
    private int ticks = 0;

    @Nullable
    static Method findMethodOrNull(Class<?> c, String methodName) {
        Method field = null;
        try {
            field = ObfuscationReflectionHelper.findMethod(c, (String)methodName, (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    @Nullable
    static Field findFieldOrNull(Class<?> c, String fieldName) {
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(c, (String)fieldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    protected CustomConfigScreen(CustomConfigSelectScreen parent, IModConfig config) {
        this(parent.getModId(), parent.getMainIcon(), parent.getBackgroundTexture(), parent.m_96636_(), (Screen)parent, config);
    }

    protected CustomConfigScreen(CustomConfigSelectScreen parent, ModConfig config) {
        this(parent.getModId(), parent.getMainIcon(), parent.getBackgroundTexture(), parent.m_96636_(), (Screen)parent, config);
    }

    protected CustomConfigScreen(String modId, ItemStack mainIcon, ResourceLocation background, Component title, Screen parent, ModConfig config) {
        this(modId, mainIcon, background, title, parent, (IModConfig)new ForgeConfig(config, (ForgeConfigSpec)config.getSpec()));
    }

    protected CustomConfigScreen(String modId, ItemStack mainIcon, ResourceLocation background, Component title, Screen parent, IModConfig config) {
        super(parent, title, config, background);
        this.modId = modId;
        this.mainIcon = mainIcon;
    }

    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        super.constructEntries(entries);
        ArrayList<ListMenuScreen.Item> copy = new ArrayList<ListMenuScreen.Item>(entries);
        entries.clear();
        ListIterator iter = copy.listIterator();
        while (iter.hasNext()) {
            ListMenuScreen.Item e = (ListMenuScreen.Item)iter.next();
            if (!e.getLabel().toLowerCase(Locale.ROOT).equals(this.getEnabledKeyword())) continue;
            iter.remove();
            entries.add(e);
        }
        entries.addAll(copy);
    }

    public ItemStack getIcon(String ... path) {
        String last = path[path.length - 1];
        if (path.length > 1 && last.equals(this.getEnabledKeyword())) {
            last = path[path.length - 2];
        }
        if (!this.icons.containsKey(last = last.toLowerCase(Locale.ROOT).replace("_", " "))) {
            String formatted = last.toLowerCase(Locale.ROOT).replace(" ", "_");
            Optional item = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(this.modId, formatted));
            String finalLast = last;
            item.ifPresent(value -> this.addIcon(finalLast, value.m_5456_().m_7968_()));
        }
        return this.icons.getOrDefault(last, ItemStack.f_41583_);
    }

    private void addIcon(String s, ItemStack i) {
        this.icons.put(s, i);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.list.m_5988_(this.replaceItems(this.list.m_6702_()));
        Collection<ListMenuScreen.Item> temp = this.replaceItems(this.entries);
        this.entries = new ArrayList<ListMenuScreen.Item>(temp);
        if (this.saveButton != null && SAVE_CONFIG != null && BUTTON_ON_PRESS != null) {
            try {
                Button.OnPress press = this::saveButtonAction;
                BUTTON_ON_PRESS.set(this.saveButton, press);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Collection<ListMenuScreen.Item> replaceItems(Collection<ListMenuScreen.Item> originals) {
        ArrayList<ListMenuScreen.Item> newList = new ArrayList<ListMenuScreen.Item>();
        for (ListMenuScreen.Item c : originals) {
            ConfigScreen.BooleanItem b;
            Object wrapper;
            if (c instanceof ConfigScreen.FolderItem) {
                ConfigScreen.FolderItem f = (ConfigScreen.FolderItem)c;
                wrapper = this.wrapFolderItem(f);
                if (wrapper != null) {
                    newList.add((ListMenuScreen.Item)wrapper);
                    continue;
                }
            } else if (c instanceof ConfigScreen.BooleanItem && (wrapper = this.wrapBooleanItem(b = (ConfigScreen.BooleanItem)c)) != null) {
                newList.add((ListMenuScreen.Item)wrapper);
                continue;
            }
            newList.add(c);
        }
        return newList;
    }

    private void saveButtonAction(Button button) {
        if (this.config != null) {
            try {
                SAVE_CONFIG.invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isChanged(this.folderEntry)) {
                this.onSave();
            }
        }
        this.f_96541_.m_91152_(this.parent);
    }

    public abstract void onSave();

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 35;
        this.f_96542_.m_274336_(poseStack, this.mainIcon, this.f_96543_ / 2 + titleWidth / 2 - 17, 2);
        this.f_96542_.m_274336_(poseStack, this.mainIcon, this.f_96543_ / 2 - titleWidth / 2, 2);
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.ticks;
    }

    @Nullable
    public FolderWrapper wrapFolderItem(ConfigScreen.FolderItem old) {
        try {
            String oldName = old.getLabel();
            IConfigEntry found = null;
            for (IConfigEntry e : this.folderEntry.getChildren()) {
                String n;
                if (e instanceof ValueEntry || !(n = Component.m_237113_((String)ConfigScreen.createLabel((String)e.getEntryName())).getString()).equals(oldName)) continue;
                found = e;
                break;
            }
            if (found != null) {
                return new FolderWrapper(found, oldName);
            }
        }
        catch (Exception ignored) {
            Moonlight.LOGGER.error("error", (Throwable)ignored);
        }
        return null;
    }

    public abstract CustomConfigScreen createSubScreen(Component var1);

    public String getEnabledKeyword() {
        return "enabled";
    }

    public List<ConfigSpec> getCustomSpecs() {
        return List.of();
    }

    @Nullable
    public BooleanWrapper wrapBooleanItem(ConfigScreen.BooleanItem old) {
        try {
            IConfigValue holder = (IConfigValue)CONFIG_VALUE_HOLDER.get(old);
            ValueEntry found = null;
            for (IConfigEntry e : this.folderEntry.getChildren()) {
                ValueEntry value;
                if (!(e instanceof ValueEntry) || holder != (value = (ValueEntry)e).getValue()) continue;
                found = value;
            }
            if (found != null) {
                String[] path = (String[])((ForgeValue)holder).configValue.getPath().toArray(String[]::new);
                ItemStack icon = this.getIcon(path);
                return new BooleanWrapper((IConfigValue<Boolean>)holder, icon);
            }
        }
        catch (Exception ignored) {
            Moonlight.LOGGER.error("error");
        }
        return null;
    }

    private static void rotateItem(int ticks, float partialTicks, PoseStack s, BakedModel m) {
        if (ticks != 0) {
            float p = (float)Math.PI / 180;
            if (m.m_7547_()) {
                s.m_252781_(Axis.f_252436_.m_252961_(((float)ticks + partialTicks) * p * 10.0f));
            } else {
                float scale = 1.0f + 0.1f * Mth.m_14031_((float)(((float)ticks + partialTicks) * p * 20.0f));
                s.m_85841_(scale, scale, scale);
            }
        }
    }

    private class FolderWrapper
    extends ConfigScreen.FolderItem {
        private final ItemStack icon;
        protected final Button button;
        protected boolean light;
        private int ticks;
        private int lastTick;

        private FolderWrapper(IConfigEntry folderEntry, String label) {
            super((ConfigScreen)CustomConfigScreen.this, folderEntry);
            this.ticks = 0;
            this.lastTick = 1;
            this.button = Button.m_253074_((Component)Component.m_237113_((String)label).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE), onPress -> {
                MutableComponent newTitle = CustomConfigScreen.this.f_96539_.m_6879_().m_130946_(" > " + label);
                CustomConfigScreen sc = CustomConfigScreen.this.createSubScreen((Component)newTitle);
                try {
                    FOLDER_ENTRY.set((Object)sc, folderEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CustomConfigScreen.this.f_96541_.m_91152_((Screen)sc);
            }).m_252987_(10, 5, 44, 20).m_253136_();
            ItemStack i = CustomConfigScreen.this.getIcon(label.toLowerCase(Locale.ROOT));
            this.icon = i.m_41619_() ? CustomConfigScreen.this.mainIcon : i;
            this.light = this.getFolderEnabledValue(folderEntry);
        }

        private boolean getFolderEnabledValue(IConfigEntry entry) {
            for (IConfigEntry c : entry.getChildren()) {
                Object object;
                IConfigValue value = c.getValue();
                if (value == null || !value.getName().equals(CustomConfigScreen.this.getEnabledKeyword()) || !((object = value.get()) instanceof Boolean)) continue;
                Boolean b = (Boolean)object;
                return b;
            }
            return true;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        public void m_6311_(PoseStack matrixStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int light;
            int n = light = this.light ? 0xF000F0 : 0;
            if (this.lastTick < CustomConfigScreen.this.ticks) {
                this.ticks = Math.max(0, this.ticks + (hovered ? 1 : -2)) % 36;
            }
            this.lastTick = CustomConfigScreen.this.ticks;
            this.button.m_252865_(left - 1);
            this.button.m_253211_(top);
            this.button.m_93674_(width);
            this.button.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
            int center = this.button.m_252754_() + width / 2;
            ItemRenderer renderer = CustomConfigScreen.this.f_96542_;
            RenderUtil.renderGuiItemRelative(matrixStack, this.icon, center + 95 - 17, top + 2, renderer, (s, m) -> CustomConfigScreen.rotateItem(this.ticks, partialTicks, s, m), light, OverlayTexture.f_118083_);
            RenderUtil.renderGuiItemRelative(matrixStack, this.icon, center - 95, top + 2, renderer, (s, m) -> CustomConfigScreen.rotateItem(this.ticks, partialTicks, s, m), light, OverlayTexture.f_118083_);
        }
    }

    private class BooleanWrapper
    extends ConfigScreen.BooleanItem {
        private static final int ICON_SIZE = 12;
        private final ItemStack item;
        protected final int iconOffset;
        protected final boolean needsGameRestart;
        protected boolean doesNeedsGameRestart;
        protected Button button;
        private int ticks;
        private int lastTick;

        public BooleanWrapper(IConfigValue<Boolean> holder, ItemStack item) {
            super((ConfigScreen)CustomConfigScreen.this, holder);
            this.doesNeedsGameRestart = false;
            this.ticks = 0;
            this.lastTick = 1;
            try {
                this.button = (Button)BOOLEAN_ITEM_BUTTON.get((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.button.m_93666_((Component)Component.m_237113_((String)""));
            this.needsGameRestart = this.hackyCheckIfValueNeedsGameRestart(holder);
            this.item = item;
            this.iconOffset = item.m_41619_() ? 0 : 7;
        }

        public BooleanWrapper(IConfigValue<Boolean> holder) {
            this(holder, ItemStack.f_41583_);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            boolean r = super.m_6375_(mouseX, mouseY, button);
            this.doesNeedsGameRestart = !this.doesNeedsGameRestart;
            return r;
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.button.m_93666_((Component)Component.m_237113_((String)""));
            super.m_6311_(poseStack, index, top, left, width, height, mouseX, mouseY, hovered, partialTicks);
            hovered = this.button.m_5953_((double)mouseX, (double)mouseY);
            if (this.lastTick < CustomConfigScreen.this.ticks) {
                this.ticks = Math.max(0, this.ticks + (hovered ? 1 : -2)) % 36;
                if (!hovered && this.ticks > 17) {
                    this.ticks %= 18;
                }
            }
            this.lastTick = CustomConfigScreen.this.ticks;
            if (this.doesNeedsGameRestart) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Screen.m_93160_((PoseStack)poseStack, (int)(left - 18), (int)(top + 5), (int)11, (int)11, (float)51.0f, (float)22.0f, (int)11, (int)11, (int)64, (int)64);
                if (MthUtils.isWithinRectangle(left - 18, top + 5, 11, 11, mouseX, mouseY)) {
                    String translationKey = "configured.gui.requires_game_restart";
                    int outline = -1438090048;
                    CustomConfigScreen.this.setActiveTooltip((Component)Component.m_237115_((String)translationKey), outline);
                }
            }
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CustomConfigSelectScreen.MISC_ICONS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int iconX = this.iconOffset + (int)((double)this.button.m_252754_() + Math.ceil((float)(this.button.m_5711_() - 12) / 2.0f));
            int iconY = (int)((double)this.button.m_252907_() + Math.ceil((float)(this.button.m_93694_() - 12) / 2.0f));
            boolean on = (Boolean)this.holder.get();
            int u = on ? 12 : 0;
            GuiComponent.m_93143_((PoseStack)poseStack, (int)iconX, (int)iconY, (int)0, (float)u, (float)0.0f, (int)12, (int)12, (int)64, (int)64);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.item.m_41619_()) {
                int light = on ? 0xF000F0 : 0;
                int center = (int)((float)this.button.m_252754_() + (float)this.button.m_5711_() / 2.0f);
                ItemRenderer renderer = CustomConfigScreen.this.f_96542_;
                RenderUtil.renderGuiItemRelative(poseStack, this.item, center - 8 - this.iconOffset, top + 2, renderer, (s, m) -> CustomConfigScreen.rotateItem(this.ticks, partialTicks, s, m), light, OverlayTexture.f_118083_);
            }
        }

        private boolean hackyCheckIfValueNeedsGameRestart(IConfigValue<Boolean> value) {
            for (ConfigSpec v : CustomConfigScreen.this.getCustomSpecs()) {
                if (!v.getFileName().equals(CustomConfigScreen.this.config.getFileName())) continue;
                return ((ConfigSpecWrapper)v).requiresGameRestart(((ForgeValue)value).configValue);
            }
            return false;
        }

        public void onResetValue() {
            this.button.m_93666_((Component)Component.m_237113_((String)""));
        }
    }
}

