/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration.configured;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.impl.forge.ForgeConfig;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.integration.configured.CustomConfigScreen;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.forge.ConfigSpecWrapper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;

public class CustomConfigSelectScreen
extends ModConfigSelectionScreen {
    public static final ResourceLocation MISC_ICONS = Moonlight.res("textures/gui/misc_icons.png");
    private static final Field FILE_ITEM_BUTTON = CustomConfigScreen.findFieldOrNull(ModConfigSelectionScreen.FileItem.class, "modifyButton");
    private static final Field FILE_ITEM_CONFIG = CustomConfigScreen.findFieldOrNull(ModConfigSelectionScreen.FileItem.class, "config");
    private final BiFunction<CustomConfigSelectScreen, IModConfig, CustomConfigScreen> configScreenFactory;
    private final ItemStack mainIcon;
    private final String modId;
    private final String modURL;

    @Deprecated(forRemoval=true)
    public CustomConfigSelectScreen(String modId, ItemStack mainIcon, String displayName, ResourceLocation background, Screen parent, BiFunction<CustomConfigSelectScreen, IModConfig, CustomConfigScreen> configScreenFactory, ConfigSpec ... specs) {
        this(modId, mainIcon, displayName, background, parent, configScreenFactory, CustomConfigSelectScreen.createConfigMap((ConfigSpecWrapper[])specs));
    }

    public CustomConfigSelectScreen(String modId, ItemStack mainIcon, String displayName, ResourceLocation background, Screen parent, BiFunction<CustomConfigSelectScreen, IModConfig, CustomConfigScreen> configScreenFactory, ConfigSpecWrapper ... specs) {
        this(modId, mainIcon, displayName, background, parent, configScreenFactory, CustomConfigSelectScreen.createConfigMap(specs));
    }

    public CustomConfigSelectScreen(String modId, ItemStack mainIcon, String displayName, ResourceLocation background, Screen parent, BiFunction<CustomConfigSelectScreen, IModConfig, CustomConfigScreen> configScreenFactory, Map<ConfigType, Set<IModConfig>> configMap) {
        super(parent, (Component)Component.m_237113_((String)displayName), background, configMap);
        this.configScreenFactory = configScreenFactory;
        this.mainIcon = mainIcon;
        this.modId = modId;
        ModContainer container = (ModContainer)ModList.get().getModContainerById(modId).get();
        this.modURL = container.getModInfo().getModURL().map(URL::getPath).orElse(null);
    }

    public ItemStack getMainIcon() {
        return this.mainIcon;
    }

    public ResourceLocation getBackgroundTexture() {
        return super.getBackgroundTexture();
    }

    public String getModId() {
        return this.modId;
    }

    public static void registerConfigScreen(String modId, Function<Screen, CustomConfigSelectScreen> screenSelectFactory) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(modId).get();
        container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((m, s) -> (Screen)screenSelectFactory.apply((Screen)s)));
    }

    private static Map<ConfigType, Set<IModConfig>> createConfigMap(ConfigSpecWrapper ... specs) {
        EnumMap<ConfigType, Set<IModConfig>> modConfigMap = new EnumMap<ConfigType, Set<IModConfig>>(ConfigType.class);
        for (ConfigSpecWrapper s : specs) {
            ModConfig modConfig = s.getModConfig();
            ForgeConfig c = new ForgeConfig(modConfig, (ForgeConfigSpec)modConfig.getSpec());
            Set set = modConfigMap.computeIfAbsent(c.getType(), a -> new HashSet());
            set.add(c);
        }
        return modConfigMap;
    }

    private static ConfigType getType(ConfigSpecWrapper s) {
        net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType t = s.getConfigType();
        if (t == net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType.CLIENT) {
            return ConfigType.CLIENT;
        }
        if (t == net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType.COMMON) {
            return ConfigType.UNIVERSAL;
        }
        return ConfigType.UNIVERSAL;
    }

    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        super.constructEntries(entries);
        for (ListMenuScreen.Item i : entries) {
            if (!(i instanceof ModConfigSelectionScreen.FileItem)) continue;
            ModConfigSelectionScreen.FileItem item = (ModConfigSelectionScreen.FileItem)i;
            try {
                FILE_ITEM_BUTTON.setAccessible(true);
                FILE_ITEM_CONFIG.setAccessible(true);
                FILE_ITEM_BUTTON.set(i, this.createModifyButton((IModConfig)FILE_ITEM_CONFIG.get(item)));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private Button createModifyButton(IModConfig config) {
        String langKey = "configured.gui.modify";
        return new IconButton(0, 0, 33, 0, 60, (Component)Component.m_237115_((String)langKey), onPress -> Minecraft.m_91087_().m_91152_((Screen)this.configScreenFactory.apply(this, config)));
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 35;
        this.f_96542_.m_274336_(poseStack, this.mainIcon, this.f_96543_ / 2 + titleWidth / 2 - 17, 2);
        this.f_96542_.m_274336_(poseStack, this.mainIcon, this.f_96543_ / 2 - titleWidth / 2, 2);
        if (this.modURL != null && MthUtils.isWithinRectangle(this.f_96543_ / 2 - 90, 2, 180, 16, mouseX, mouseY)) {
            this.m_96617_(poseStack, this.f_96547_.m_92923_((FormattedText)Component.m_237110_((String)"gui.moonlight.open_mod_page", (Object[])new Object[]{this.modId}), 200), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.modURL != null && MthUtils.isWithinRectangle(this.f_96543_ / 2 - 90, 2, 180, 16, (int)mouseX, (int)mouseY)) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, this.modURL));
            this.m_5561_(style);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

