/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public class ConfigSpecWrapper
extends ConfigSpec {
    private static final Method SET_CONFIG_DATA = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
    private static final Method SETUP_CONFIG_FILE = ObfuscationReflectionHelper.findMethod(ConfigFileTypeHandler.class, (String)"setupConfigFile", (Class[])new Class[]{ModConfig.class, Path.class, ConfigFormat.class});
    private final ForgeConfigSpec spec;
    private final ModConfig modConfig;
    private final ModContainer modContainer;
    private final Map<ForgeConfigSpec.ConfigValue<?>, Object> requireRestartValues;

    public ConfigSpecWrapper(ResourceLocation name, ForgeConfigSpec spec, ConfigType type, boolean synced, @Nullable Runnable onChange, List<ForgeConfigSpec.ConfigValue<?>> requireRestart) {
        super(name, FMLPaths.CONFIGDIR.get(), type, synced, onChange);
        this.spec = spec;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (onChange != null || this.isSynced()) {
            bus.addListener(this::onConfigChange);
        }
        if (this.isSynced()) {
            MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
            MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedOut);
        }
        ModConfig.Type t = this.getConfigType() == ConfigType.COMMON ? ModConfig.Type.COMMON : ModConfig.Type.CLIENT;
        this.modContainer = ModLoadingContext.get().getActiveContainer();
        this.modConfig = new ModConfig(t, (IConfigSpec)spec, this.modContainer, name.m_135827_() + "-" + name.m_135815_() + ".toml");
        ConfigSpec.addTrackedSpec(this);
        if (!requireRestart.isEmpty()) {
            this.loadFromFile();
        }
        this.requireRestartValues = requireRestart.stream().collect(Collectors.toMap(e -> e, ForgeConfigSpec.ConfigValue::get));
    }

    @Override
    public String getFileName() {
        return this.modConfig.getFileName();
    }

    @Override
    public Component getName() {
        return Component.m_237113_((String)this.getFileName());
    }

    @Override
    public Path getFullPath() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getFileName());
    }

    @Override
    public void register() {
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        modContainer.addConfig(this.modConfig);
    }

    @Override
    public void loadFromFile() {
        try {
            CommentedFileConfig configData = this.readConfig(this.modConfig.getHandler(), FMLPaths.CONFIGDIR.get(), this.modConfig);
            SET_CONFIG_DATA.setAccessible(true);
            SET_CONFIG_DATA.invoke((Object)this.modConfig, configData);
            this.modContainer.dispatchConfigEvent(IConfigEvent.loading((ModConfig)this.modConfig));
            this.modConfig.save();
        }
        catch (Exception e) {
            throw new ConfigLoadingException(this.modConfig, e);
        }
    }

    private CommentedFileConfig readConfig(ConfigFileTypeHandler handler, Path configBasePath, ModConfig c) {
        Path configPath = configBasePath.resolve(c.getFileName());
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().autosave().onFileNotFound((newfile, configFormat) -> {
            try {
                return (Boolean)SETUP_CONFIG_FILE.invoke((Object)handler, c, newfile, configFormat);
            }
            catch (Exception e) {
                throw new ConfigLoadingException(c, e);
            }
        }).writingMode(WritingMode.REPLACE).build();
        configData.load();
        return configData;
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    @Nullable
    public ModConfig getModConfig() {
        return this.modConfig;
    }

    public ModConfig.Type getModConfigType() {
        return this.getConfigType() == ConfigType.CLIENT ? ModConfig.Type.CLIENT : ModConfig.Type.COMMON;
    }

    @Override
    public boolean isLoaded() {
        return this.spec.isLoaded();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen makeScreen(Screen parent, @Nullable ResourceLocation background) {
        Optional factory;
        Optional container = ModList.get().getModContainerById(this.getModId());
        if (container.isPresent() && (factory = ((ModContainer)container.get()).getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class)).isPresent()) {
            return (Screen)((ConfigScreenHandler.ConfigScreenFactory)factory.get()).screenFunction().apply(Minecraft.m_91087_(), parent);
        }
        return null;
    }

    @Override
    public boolean hasConfigScreen() {
        return ModList.get().getModContainerById(this.getModId()).map(container -> container.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).isPresent()).orElse(false);
    }

    protected void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.syncConfigsToPlayer(serverPlayer);
        }
    }

    protected void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            this.onRefresh();
        }
    }

    protected void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == this.getSpec()) {
            if (this.isSynced() && PlatHelper.getPhysicalSide().isServer()) {
                this.sendSyncedConfigsToAllPlayers();
            }
            this.onRefresh();
        }
    }

    @Override
    public void loadFromBytes(InputStream stream) {
        try {
            byte[] b = stream.readAllBytes();
            this.modConfig.acceptSyncedConfig(b);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to sync config file {}:", (Object)this.getFileName(), (Object)e);
        }
    }

    public boolean requiresGameRestart(ForgeConfigSpec.ConfigValue<?> value) {
        Object v = this.requireRestartValues.get(value);
        if (v == null) {
            return false;
        }
        return v != value.get();
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for modid " + config.getModId() + ". Try deleting it", cause);
        }
    }
}

