/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientBoundSyncCustomMapDecorationMessage
implements Message {
    private final int mapId;
    private final byte scale;
    private final boolean locked;
    private final CustomMapDecoration[] customDecorations;
    private final CustomDataHolder.Instance<?>[] customData;

    public ClientBoundSyncCustomMapDecorationMessage(int mapId, byte pScale, boolean pLocked, CustomMapDecoration[] customDecorations, CustomDataHolder.Instance<?>[] customData) {
        this.mapId = mapId;
        this.scale = pScale;
        this.locked = pLocked;
        this.customData = customData;
        this.customDecorations = customDecorations;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.mapId);
        buffer.writeByte((int)this.scale);
        buffer.writeBoolean(this.locked);
        buffer.m_130130_(this.customDecorations.length);
        for (CustomMapDecoration decoration : this.customDecorations) {
            buffer.m_130085_(Utils.getID(decoration.getType()));
            decoration.saveToBuffer(buffer);
        }
        buffer.m_130130_(this.customData.length);
        for (CustomDataHolder.Instance<?> data : this.customData) {
            buffer.m_130085_(data.getType().id());
            data.saveToBuffer(buffer);
        }
    }

    public ClientBoundSyncCustomMapDecorationMessage(FriendlyByteBuf pBuffer) {
        Object type;
        int m;
        this.mapId = pBuffer.m_130242_();
        this.scale = pBuffer.readByte();
        this.locked = pBuffer.readBoolean();
        this.customDecorations = new CustomMapDecoration[pBuffer.m_130242_()];
        for (m = 0; m < this.customDecorations.length; ++m) {
            type = MapDecorationRegistry.get(pBuffer.m_130281_());
            if (type == null) continue;
            this.customDecorations[m] = ((MapDecorationType)type).loadDecorationFromBuffer(pBuffer);
        }
        this.customData = new CustomDataHolder.Instance[pBuffer.m_130242_()];
        for (m = 0; m < this.customData.length; ++m) {
            type = MapDecorationRegistry.CUSTOM_MAP_DATA_TYPES.getOrDefault(pBuffer.m_130281_(), null);
            if (type == null) continue;
            this.customData[m] = ((CustomDataHolder)type).createFromBuffer(pBuffer);
        }
    }

    @Override
    public void handle(ChannelHandler.Context context) {
        if (context.getDirection() == NetworkDir.PLAY_TO_CLIENT) {
            MapRenderer mapRenderer = Minecraft.m_91087_().f_91063_.m_109151_();
            int i = this.getMapId();
            String s = MapItem.m_42848_((int)i);
            MapItemSavedData mapData = Minecraft.m_91087_().f_91073_.m_7489_(s);
            if (mapData != null) {
                this.applyToMap(mapData);
                mapRenderer.m_168765_(i, mapData);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMapId() {
        return this.mapId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyToMap(MapItemSavedData data) {
        if (data instanceof ExpandedMapData) {
            ExpandedMapData mapData = (ExpandedMapData)data;
            Map<String, CustomMapDecoration> decorations = mapData.getCustomDecorations();
            decorations.clear();
            for (int i = 0; i < this.customDecorations.length; ++i) {
                CustomMapDecoration customDecoration = this.customDecorations[i];
                if (customDecoration != null) {
                    decorations.put("icon-" + i, customDecoration);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to load custom map decoration, skipping");
            }
            Map<ResourceLocation, CustomDataHolder.Instance<?>> customData = mapData.getCustomData();
            customData.clear();
            for (CustomDataHolder.Instance<?> instance : this.customData) {
                if (instance != null) {
                    customData.put(instance.getType().id(), instance);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to load custom map data, skipping");
            }
        }
    }
}

