/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.ModInfo;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.HungerHelper;
import squeek.appleskin.util.IntPoint;

@OnlyIn(value=Dist.CLIENT)
public class HUDOverlayHandler {
    private static float unclampedFlashAlpha = 0.0f;
    private static float flashAlpha = 0.0f;
    private static byte alphaDir = 1;
    protected static int foodIconsOffset;
    public static final Vector<IntPoint> healthBarOffsets;
    public static final Vector<IntPoint> foodBarOffsets;
    private static final Random random;
    private static final ResourceLocation modIcons;
    static ResourceLocation FOOD_LEVEL_ELEMENT;
    static ResourceLocation PLAYER_HEALTH_ELEMENT;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new HUDOverlayHandler());
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPre(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)FOOD_LEVEL_ELEMENT)) {
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            boolean isMounted = mc.f_91074_.m_20202_() instanceof LivingEntity;
            if (!isMounted && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                HUDOverlayHandler.renderExhaustion(gui, event.getPoseStack(), event.getPartialTick(), event.getWindow().m_85443_(), event.getWindow().m_85444_());
            }
        }
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)FOOD_LEVEL_ELEMENT)) {
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            boolean isMounted = mc.f_91074_.m_20202_() instanceof LivingEntity;
            if (!isMounted && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                HUDOverlayHandler.renderFoodOrHealthOverlay(gui, event.getPoseStack(), event.getPartialTick(), event.getWindow().m_85443_(), event.getWindow().m_85444_(), RenderOverlayType.FOOD);
            }
        } else if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)PLAYER_HEALTH_ELEMENT)) {
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                HUDOverlayHandler.renderFoodOrHealthOverlay(gui, event.getPoseStack(), event.getPartialTick(), event.getWindow().m_85443_(), event.getWindow().m_85444_(), RenderOverlayType.HEALTH);
            }
        }
    }

    public static void renderExhaustion(ForgeGui gui, PoseStack mStack, float partialTicks, int screenWidth, int screenHeight) {
        foodIconsOffset = gui.rightHeight;
        if (!((Boolean)ModConfig.SHOW_FOOD_EXHAUSTION_UNDERLAY.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        int right = mc.m_91268_().m_85445_() / 2 + 91;
        int top = mc.m_91268_().m_85446_() - foodIconsOffset;
        float exhaustion = player.m_36324_().m_150380_();
        HUDOverlayEvent.Exhaustion renderEvent = new HUDOverlayEvent.Exhaustion(exhaustion, right, top, mStack);
        MinecraftForge.EVENT_BUS.post((Event)renderEvent);
        if (!renderEvent.isCanceled()) {
            HUDOverlayHandler.drawExhaustionOverlay(renderEvent, mc, 1.0f);
        }
    }

    public static void renderFoodOrHealthOverlay(ForgeGui gui, PoseStack mStack, float partialTicks, int screenWidth, int screenHeight, RenderOverlayType type) {
        boolean shouldRenderHeldItemValues;
        if (!HUDOverlayHandler.shouldRenderAnyOverlays()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        FoodData stats = player.m_36324_();
        PoseStack poseStack = mStack;
        int top = mc.m_91268_().m_85446_() - foodIconsOffset;
        int left = mc.m_91268_().m_85445_() / 2 - 91;
        int right = mc.m_91268_().m_85445_() / 2 + 91;
        if (type == RenderOverlayType.HEALTH) {
            HUDOverlayHandler.generateHealthBarOffsets(top, left, right, mc.f_91065_.m_93079_(), (Player)player);
        }
        if (type == RenderOverlayType.FOOD) {
            HUDOverlayHandler.generateHungerBarOffsets(top, left, right, mc.f_91065_.m_93079_(), (Player)player);
        }
        HUDOverlayEvent.Saturation saturationRenderEvent = null;
        if (type == RenderOverlayType.FOOD) {
            saturationRenderEvent = new HUDOverlayEvent.Saturation(stats.m_38722_(), right, top, poseStack);
            if (!((Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get()).booleanValue()) {
                saturationRenderEvent.setCanceled(true);
            }
            if (!saturationRenderEvent.isCanceled()) {
                MinecraftForge.EVENT_BUS.post((Event)saturationRenderEvent);
            }
            if (!saturationRenderEvent.isCanceled()) {
                HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, mc, 0.0f, 1.0f);
            }
        }
        ItemStack heldItem = player.m_21205_();
        if (((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY_WHEN_OFFHAND.get()).booleanValue() && !FoodHelper.canConsume(heldItem, (Player)player)) {
            heldItem = player.m_21206_();
        }
        boolean bl = shouldRenderHeldItemValues = !heldItem.m_41619_() && FoodHelper.canConsume(heldItem, (Player)player);
        if (!shouldRenderHeldItemValues) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        FoodValues modifiedFoodValues = FoodHelper.getModifiedFoodValues(heldItem, (Player)player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent((Player)player, heldItem, FoodHelper.getDefaultFoodValues(heldItem, (Player)player), modifiedFoodValues);
        MinecraftForge.EVENT_BUS.post((Event)foodValuesEvent);
        modifiedFoodValues = foodValuesEvent.modifiedFoodValues;
        if (type == RenderOverlayType.HEALTH) {
            if (healthBarOffsets.size() == 0) {
                return;
            }
            if (!HUDOverlayHandler.shouldShowEstimatedHealth(heldItem, modifiedFoodValues)) {
                return;
            }
            float foodHealthIncrement = FoodHelper.getEstimatedHealthIncrement(heldItem, modifiedFoodValues, (Player)player);
            float currentHealth = player.m_21223_();
            float modifiedHealth = Math.min(currentHealth + foodHealthIncrement, player.m_21233_());
            HUDOverlayEvent.HealthRestored healthRenderEvent = null;
            if (currentHealth < modifiedHealth) {
                healthRenderEvent = new HUDOverlayEvent.HealthRestored(modifiedHealth, heldItem, modifiedFoodValues, left, top, poseStack);
            }
            if (healthRenderEvent != null) {
                MinecraftForge.EVENT_BUS.post(healthRenderEvent);
            }
            if (healthRenderEvent != null && !healthRenderEvent.isCanceled()) {
                HUDOverlayHandler.drawHealthOverlay(healthRenderEvent, mc, flashAlpha);
            }
        } else if (type == RenderOverlayType.FOOD) {
            if (!((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get()).booleanValue()) {
                return;
            }
            HUDOverlayEvent.HungerRestored renderRenderEvent = new HUDOverlayEvent.HungerRestored(stats.m_38702_(), heldItem, modifiedFoodValues, right, top, poseStack);
            MinecraftForge.EVENT_BUS.post((Event)renderRenderEvent);
            if (renderRenderEvent.isCanceled()) {
                return;
            }
            int foodHunger = modifiedFoodValues.hunger;
            float foodSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
            HUDOverlayHandler.drawHungerOverlay(renderRenderEvent, mc, foodHunger, flashAlpha, FoodHelper.isRotten(heldItem, (Player)player));
            assert (saturationRenderEvent != null);
            if (!saturationRenderEvent.isCanceled()) {
                int newFoodValue = stats.m_38702_() + foodHunger;
                float newSaturationValue = stats.m_38722_() + foodSaturationIncrement;
                float saturationGained = newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.m_38722_() : foodSaturationIncrement;
                HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, mc, saturationGained, flashAlpha);
            }
        }
    }

    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, Minecraft mc, PoseStack poseStack, int right, int top, float alpha) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)modIcons);
        float modifiedSaturation = Math.max(0.0f, Math.min(saturationLevel + saturationGained, 20.0f));
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        if (saturationGained != 0.0f) {
            startSaturationBar = (int)Math.max(saturationLevel / 2.0f, 0.0f);
        }
        int iconSize = 9;
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = 1 * iconSize;
            }
            Gui cfr_ignored_0 = mc.f_91065_;
            Gui.m_93228_((PoseStack)poseStack, (int)x, (int)y, (int)u, (int)v, (int)iconSize, (int)iconSize);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawHungerOverlay(int hungerRestored, int foodLevel, Minecraft mc, PoseStack poseStack, int right, int top, float alpha, boolean useRottenTextures) {
        if (hungerRestored <= 0) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        int modifiedFood = Math.max(0, Math.min(20, foodLevel + hungerRestored));
        int startFoodBars = Math.max(0, foodLevel / 2);
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconStartOffset = 16;
        int iconSize = 9;
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 3 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            int ub = iconStartOffset + 1 * iconSize;
            if (useRottenTextures) {
                u += 4 * iconSize;
                ub += 12 * iconSize;
            }
            if (i * 2 + 1 == modifiedFood) {
                u += 1 * iconSize;
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            Gui cfr_ignored_0 = mc.f_91065_;
            Gui.m_93228_((PoseStack)poseStack, (int)x, (int)y, (int)ub, (int)v, (int)iconSize, (int)iconSize);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            Gui cfr_ignored_1 = mc.f_91065_;
            Gui.m_93228_((PoseStack)poseStack, (int)x, (int)y, (int)u, (int)v, (int)iconSize, (int)iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawHealthOverlay(float health, float modifiedHealth, Minecraft mc, PoseStack poseStack, int right, int top, float alpha) {
        if (modifiedHealth <= health) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        int fixedModifiedHealth = (int)Math.ceil(modifiedHealth);
        boolean isHardcore = mc.f_91074_.f_19853_ != null && mc.f_91074_.f_19853_.m_6106_().m_5466_();
        int startHealthBars = (int)Math.max(0.0, Math.ceil(health) / 2.0);
        int endHealthBars = (int)Math.max(0.0, Math.ceil(modifiedHealth / 2.0f));
        int iconStartOffset = 16;
        int iconSize = 9;
        for (int i = startHealthBars; i < endHealthBars; ++i) {
            IntPoint offset = healthBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            int ub = iconStartOffset + 1 * iconSize;
            if (i * 2 + 1 == fixedModifiedHealth) {
                u += 1 * iconSize;
            }
            if (isHardcore) {
                v = 5 * iconSize;
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            Gui cfr_ignored_0 = mc.f_91065_;
            Gui.m_93228_((PoseStack)poseStack, (int)x, (int)y, (int)ub, (int)v, (int)iconSize, (int)iconSize);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            Gui cfr_ignored_1 = mc.f_91065_;
            Gui.m_93228_((PoseStack)poseStack, (int)x, (int)y, (int)u, (int)v, (int)iconSize, (int)iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawExhaustionOverlay(float exhaustion, Minecraft mc, PoseStack poseStack, int right, int top, float alpha) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)modIcons);
        float maxExhaustion = HungerHelper.getMaxExhaustion((Player)mc.f_91074_);
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        Gui cfr_ignored_0 = mc.f_91065_;
        Gui.m_93228_((PoseStack)poseStack, (int)(right - width), (int)top, (int)(81 - width), (int)18, (int)width, (int)height);
        HUDOverlayHandler.disableAlpha(0.75f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    public static void enableAlpha(float alpha) {
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_69405_((int)770, (int)771);
    }

    public static void disableAlpha(float alpha) {
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if ((unclampedFlashAlpha += (float)alphaDir * 0.125f) >= 1.5f) {
            alphaDir = (byte)-1;
        } else if (unclampedFlashAlpha <= -0.5f) {
            alphaDir = 1;
        }
        flashAlpha = Math.max(0.0f, Math.min(1.0f, unclampedFlashAlpha)) * Math.max(0.0f, Math.min(1.0f, ((Double)ModConfig.MAX_HUD_OVERLAY_FLASH_ALPHA.get()).floatValue()));
    }

    public static void resetFlash() {
        flashAlpha = 0.0f;
        unclampedFlashAlpha = 0.0f;
        alphaDir = 1;
    }

    private static void drawSaturationOverlay(HUDOverlayEvent.Saturation event, Minecraft mc, float saturationGained, float alpha) {
        HUDOverlayHandler.drawSaturationOverlay(saturationGained, event.saturationLevel, mc, event.matrixStack, event.x, event.y, alpha);
    }

    private static void drawHungerOverlay(HUDOverlayEvent.HungerRestored event, Minecraft mc, int hunger, float alpha, boolean useRottenTextures) {
        HUDOverlayHandler.drawHungerOverlay(hunger, event.currentFoodLevel, mc, event.matrixStack, event.x, event.y, alpha, useRottenTextures);
    }

    private static void drawHealthOverlay(HUDOverlayEvent.HealthRestored event, Minecraft mc, float alpha) {
        HUDOverlayHandler.drawHealthOverlay(mc.f_91074_.m_21223_(), event.modifiedHealth, mc, event.matrixStack, event.x, event.y, alpha);
    }

    private static void drawExhaustionOverlay(HUDOverlayEvent.Exhaustion event, Minecraft mc, float alpha) {
        HUDOverlayHandler.drawExhaustionOverlay(event.exhaustion, mc, event.matrixStack, event.x, event.y, alpha);
    }

    private static boolean shouldRenderAnyOverlays() {
        return (Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get() != false || (Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get() != false || (Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get() != false;
    }

    private static boolean shouldShowEstimatedHealth(ItemStack hoveredStack, FoodValues modifiedFoodValues) {
        if (!((Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get()).booleanValue()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        FoodData stats = player.m_36324_();
        if (player.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (stats.m_38702_() >= 18) {
            return false;
        }
        if (player.m_21023_(MobEffects.f_19614_)) {
            return false;
        }
        if (player.m_21023_(MobEffects.f_19615_)) {
            return false;
        }
        return !player.m_21023_(MobEffects.f_19605_);
    }

    private static void generateHealthBarOffsets(int top, int left, int right, int ticks, Player player) {
        random.setSeed((long)ticks * 312871L);
        int preferHealthBars = 10;
        float maxHealth = player.m_21233_();
        float absorptionHealth = (float)Math.ceil(player.m_6103_());
        int healthBars = (int)Math.ceil((maxHealth + absorptionHealth) / 2.0f);
        if (healthBars < 0 || healthBars > 1000) {
            healthBarOffsets.setSize(0);
            return;
        }
        int healthRows = (int)Math.ceil((float)healthBars / 10.0f);
        int healthRowHeight = Math.max(10 - (healthRows - 2), 3);
        boolean shouldAnimatedHealth = false;
        if (((Boolean)ModConfig.SHOW_VANILLA_ANIMATION_OVERLAY.get()).booleanValue()) {
            boolean bl = shouldAnimatedHealth = Math.ceil(player.m_21223_()) <= 4.0;
        }
        if (healthBarOffsets.size() != healthBars) {
            healthBarOffsets.setSize(healthBars);
        }
        for (int i = healthBars - 1; i >= 0; --i) {
            IntPoint point;
            int row = (int)Math.ceil((float)(i + 1) / 10.0f) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * healthRowHeight;
            if (shouldAnimatedHealth) {
                y += random.nextInt(2);
            }
            if ((point = healthBarOffsets.get(i)) == null) {
                point = new IntPoint();
                healthBarOffsets.set(i, point);
            }
            point.x = x - left;
            point.y = y - top;
        }
    }

    private static void generateHungerBarOffsets(int top, int left, int right, int ticks, Player player) {
        int preferFoodBars = 10;
        boolean shouldAnimatedFood = false;
        if (((Boolean)ModConfig.SHOW_VANILLA_ANIMATION_OVERLAY.get()).booleanValue()) {
            FoodData stats = player.m_36324_();
            float saturationLevel = stats.m_38722_();
            int foodLevel = stats.m_38702_();
            boolean bl = shouldAnimatedFood = saturationLevel <= 0.0f && ticks % (foodLevel * 3 + 1) == 0;
        }
        if (foodBarOffsets.size() != 10) {
            foodBarOffsets.setSize(10);
        }
        for (int i = 0; i < 10; ++i) {
            IntPoint point;
            int x = right - i * 8 - 9;
            int y = top;
            if (shouldAnimatedFood) {
                y += random.nextInt(3) - 1;
            }
            if ((point = foodBarOffsets.get(i)) == null) {
                point = new IntPoint();
                foodBarOffsets.set(i, point);
            }
            point.x = x - right;
            point.y = y - top;
        }
    }

    static {
        healthBarOffsets = new Vector();
        foodBarOffsets = new Vector();
        random = new Random();
        modIcons = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");
        FOOD_LEVEL_ELEMENT = new ResourceLocation("minecraft", "food_level");
        PLAYER_HEALTH_ELEMENT = new ResourceLocation("minecraft", "player_health");
    }

    static enum RenderOverlayType {
        HEALTH,
        FOOD;

    }
}

