/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller.entities.goals;

import de.cadentem.cave_dweller.config.ServerConfig;
import de.cadentem.cave_dweller.entities.CaveDwellerEntity;
import de.cadentem.cave_dweller.entities.goals.Roll;
import de.cadentem.cave_dweller.util.Utils;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class CaveDwellerChaseGoal
extends Goal {
    private final CaveDwellerEntity caveDweller;
    private final int maxSpeedReached;
    private final boolean followTargetEvenIfNotSeen;
    private long lastGameTimeCheck;
    private int ticksUntilLeave;
    private int ticksUntilNextAttack;
    private int speedUp;

    public CaveDwellerChaseGoal(CaveDwellerEntity caveDweller, boolean followTargetEvenIfNotSeen) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.caveDweller = caveDweller;
        this.followTargetEvenIfNotSeen = followTargetEvenIfNotSeen;
        this.ticksUntilLeave = Utils.secondsToTicks((Integer)ServerConfig.TIME_UNTIL_LEAVE_CHASE.get());
        this.maxSpeedReached = Utils.secondsToTicks(3);
    }

    public boolean m_8036_() {
        boolean canAttack;
        if (this.caveDweller.m_20145_()) {
            return false;
        }
        if (this.caveDweller.currentRoll != Roll.CHASE) {
            return false;
        }
        if (!this.caveDweller.targetIsLookingAtMe) {
            return false;
        }
        long ticks = this.caveDweller.f_19853_.m_46467_();
        if (ticks - this.lastGameTimeCheck < 20L) {
            return false;
        }
        this.lastGameTimeCheck = ticks;
        LivingEntity target = this.caveDweller.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            return false;
        }
        Path path = this.caveDweller.m_21573_().m_6570_((Entity)target, 0);
        if (path != null) {
            return true;
        }
        boolean bl = canAttack = this.getAttackReachSqr(target) >= this.caveDweller.m_20280_((Entity)target);
        if (canAttack) {
            return true;
        }
        this.caveDweller.m_20088_().m_135381_(CaveDwellerEntity.CRAWLING_ACCESSOR, (Object)true);
        this.caveDweller.m_6210_();
        path = this.caveDweller.m_21573_().m_6570_((Entity)target, 0);
        return path != null;
    }

    public boolean m_8045_() {
        LivingEntity target = this.caveDweller.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            this.caveDweller.disappear();
            return false;
        }
        if (!this.followTargetEvenIfNotSeen) {
            return !this.caveDweller.m_21573_().m_26571_();
        }
        return this.caveDweller.m_21444_(target.m_20183_());
    }

    public void m_8056_() {
        this.caveDweller.m_21561_(true);
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.caveDweller.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            this.caveDweller.m_6710_(null);
        }
        this.speedUp = 0;
        this.caveDweller.m_21561_(false);
        this.caveDweller.m_20088_().m_135381_(CaveDwellerEntity.CRAWLING_ACCESSOR, (Object)false);
        this.caveDweller.m_21573_().m_26573_();
        this.caveDweller.m_6210_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean shouldClimb;
        LivingEntity target;
        if (this.ticksUntilLeave <= 0 && !this.caveDweller.targetIsLookingAtMe) {
            this.caveDweller.disappear();
        }
        if (!Utils.isValidPlayer((Entity)(target = this.caveDweller.m_5448_()))) {
            return;
        }
        Path path = this.caveDweller.m_21573_().m_26570_();
        if (path == null || path.m_77392_() || path.m_77395_() == null || (double)path.m_77395_().m_164702_(target.m_20183_()) > 0.5) {
            if (!this.caveDweller.m_6047_()) {
                this.caveDweller.m_20088_().m_135381_(CaveDwellerEntity.CROUCHING_ACCESSOR, (Object)true);
                this.caveDweller.m_6210_();
            }
            path = this.caveDweller.m_21573_().m_6570_((Entity)target, 0);
        }
        boolean isCrawling = false;
        boolean bl = shouldClimb = target.m_20186_() > this.caveDweller.m_20186_();
        if (!shouldClimb && this.caveDweller.m_20280_((Entity)target) > 0.3 && (path == null || path.m_77392_() || path.m_77398_() == 1)) {
            isCrawling = true;
            this.caveDweller.m_20088_().m_135381_(CaveDwellerEntity.CRAWLING_ACCESSOR, (Object)true);
            this.caveDweller.m_6210_();
            path = this.caveDweller.m_21573_().m_6570_((Entity)target, 0);
        }
        if (path != null && !path.m_77392_()) {
            if (this.caveDweller.m_142582_((Entity)target)) {
                this.caveDweller.playChaseSound();
            }
            boolean isAboveSolid = this.caveDweller.f_19853_.m_8055_(this.caveDweller.m_20183_().m_7494_()).m_60767_().m_76333_();
            boolean isNextAboveSolid = this.caveDweller.f_19853_.m_8055_(path.m_77400_().m_7494_()).m_60767_().m_76333_();
            boolean isFacingSolid = this.caveDweller.f_19853_.m_8055_(this.caveDweller.m_20183_().m_121945_(this.caveDweller.m_6350_())).m_60767_().m_76333_();
            boolean isFacingAboveSolid = this.caveDweller.f_19853_.m_8055_(this.caveDweller.m_20183_().m_121945_(this.caveDweller.m_6350_()).m_7494_()).m_60767_().m_76333_();
            boolean extraCheck = isFacingSolid && !isFacingAboveSolid;
            isCrawling = isAboveSolid || isNextAboveSolid || (Boolean)this.caveDweller.m_20088_().m_135370_(CaveDwellerEntity.CROUCHING_ACCESSOR) != false && extraCheck;
            this.caveDweller.m_20088_().m_135381_(CaveDwellerEntity.CRAWLING_ACCESSOR, (Object)isCrawling);
            this.caveDweller.m_6210_();
        }
        double speedModifier = 0.85 / (double)this.maxSpeedReached * (double)this.speedUp;
        this.caveDweller.m_21573_().m_26536_(path, isCrawling ? 0.3 : 0.85);
        if (!isCrawling) {
            if (this.caveDweller.m_5912_()) {
                this.caveDweller.m_21563_().m_24960_((Entity)target, 90.0f, 90.0f);
            } else {
                this.caveDweller.m_21563_().m_24960_((Entity)target, 180.0f, 1.0f);
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        double distance = this.caveDweller.m_20280_((Entity)target);
        this.checkAndPerformAttack(target, distance);
        --this.ticksUntilLeave;
        if (this.speedUp < this.maxSpeedReached) {
            ++this.speedUp;
        }
    }

    private void checkAndPerformAttack(LivingEntity target, double distanceToTarget) {
        double attackReach = this.getAttackReachSqr(target);
        if (distanceToTarget <= attackReach && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.caveDweller.m_6674_(InteractionHand.MAIN_HAND);
            this.caveDweller.m_7327_((Entity)target);
        }
    }

    private void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    private double getAttackReachSqr(LivingEntity target) {
        return this.caveDweller.m_20205_() * 4.0f * this.caveDweller.m_20205_() * 4.0f + target.m_20205_();
    }
}

