/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller.util;

import de.cadentem.cave_dweller.config.ServerConfig;
import de.cadentem.cave_dweller.entities.CaveDwellerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int minutesToTicks(int minutes) {
        return Utils.secondsToTicks(minutes * 60);
    }

    public static String getTextureAppend() {
        return "";
    }

    public static boolean isValidPlayer(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (!player.m_6084_()) {
            return false;
        }
        if (!((Boolean)ServerConfig.TARGET_INVISIBLE.get()).booleanValue() && player.m_20145_()) {
            return false;
        }
        return !player.m_7500_() && !player.m_5833_();
    }

    public static LivingEntity getValidTarget(@NotNull CaveDwellerEntity caveDweller) {
        return caveDweller.f_19853_.m_5788_(caveDweller.m_20182_().f_82479_, caveDweller.m_20182_().f_82480_, caveDweller.m_20182_().f_82481_, 128.0, Utils::isValidPlayer);
    }

    public static boolean isOnSurface(Entity entity) {
        if (entity == null) {
            return false;
        }
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPosition = entity.m_20183_();
            if (serverLevel.m_45527_(blockPosition)) {
                return true;
            }
            Holder biome = serverLevel.m_204166_(blockPosition);
            if (biome.m_203656_(Tags.Biomes.IS_CAVE) || biome.m_203656_(Tags.Biomes.IS_UNDERGROUND)) {
                return false;
            }
            int baseSkyLightLevel = serverLevel.m_45517_(LightLayer.SKY, blockPosition) - serverLevel.m_7445_();
            if (baseSkyLightLevel > 0) {
                return true;
            }
        }
        return false;
    }
}

