/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_block_codecs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={StateHolder.class})
public class StateHolderMixin {
    private static final LoadingCache<Block, MapCodec<BlockState>> MODERNFIX_CODEC_CACHE = CacheBuilder.newBuilder().maximumSize(100000L).build((CacheLoader)new CacheLoader<Block, MapCodec<BlockState>>(){

        public MapCodec<BlockState> load(Block block) throws Exception {
            Supplier<BlockState> stateSupplier = () -> ((Block)block).m_49966_();
            MapCodec mapCodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(stateSupplier));
            for (Property property : block.m_49965_().m_61092_()) {
                mapCodec = StateDefinition.m_61076_((MapCodec)mapCodec, stateSupplier, (String)property.m_61708_(), (Property)property);
            }
            return mapCodec;
        }
    });

    @Redirect(method={"codec"}, at=@At(value="INVOKE", target="Lcom/mojang/serialization/Codec;dispatch(Ljava/lang/String;Ljava/util/function/Function;Ljava/util/function/Function;)Lcom/mojang/serialization/Codec;", remap=false))
    private static <O, S extends StateHolder<O, S>> Codec<S> obtainCodec(Codec<O> codec, String typeKey, Function<S, O> type, Function<O, ? extends Codec<S>> codecFn, Codec<O> codecMethodArg, Function<O, S> stateSupplier) {
        return codec.dispatch(typeKey, type, block -> {
            if (block instanceof Block) {
                MapCodec mapCodec;
                StateHolder state = (StateHolder)stateSupplier.apply(block);
                if (state.m_61148_().isEmpty()) {
                    return Codec.unit((Object)state);
                }
                try {
                    mapCodec = (MapCodec)MODERNFIX_CODEC_CACHE.get((Object)((Block)block));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                return mapCodec.fieldOf("Properties").codec();
            }
            return (Codec)codecFn.apply(block);
        });
    }
}

