/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.world;

import com.mojang.logging.LogUtils;
import java.lang.ref.WeakReference;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import org.embeddedt.modernfix.world.ThreadDumper;
import org.slf4j.Logger;

public class IntegratedWatchdog
extends Thread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final WeakReference<MinecraftServer> server;
    private static final long MAX_TICK_DELTA = 40000L;

    public IntegratedWatchdog(MinecraftServer server) {
        this.server = new WeakReference<MinecraftServer>(server);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(LOGGER));
        this.setName("ModernFix integrated server watchdog");
    }

    @Override
    public void run() {
        MinecraftServer server;
        while ((server = (MinecraftServer)this.server.get()) != null && server.m_130010_()) {
            long nextTick = server.m_129932_();
            long curTime = Util.m_137550_();
            long delta = curTime - nextTick;
            if (delta > 40000L) {
                LOGGER.error("A single server tick has taken {}, more than {} milliseconds", (Object)delta, (Object)40000L);
                LOGGER.error(ThreadDumper.obtainThreadDump());
                nextTick = 0L;
                curTime = 0L;
            }
            server = null;
            try {
                Thread.sleep(nextTick + 40000L - curTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }
}

