/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.littleframes.LittleFramesConfig;
import team.creative.littleframes.LittleFramesRegistry;
import team.creative.littleframes.LittleTilesIntegration;
import team.creative.littleframes.client.LittleFramesClient;
import team.creative.littleframes.common.packet.CreativePictureFramePacket;
import team.creative.littleframes.common.packet.LittlePictureFramePacket;
import team.creative.littleframes.common.structure.LittlePictureFrame;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;
import team.creative.littletiles.common.structure.type.premade.LittleStructureBuilder;

@Mod(value="littleframes")
public class LittleFrames {
    public static final String MODID = "littleframes";
    public static LittleFramesConfig CONFIG;
    public static final Logger LOGGER;
    public static final CreativeNetwork NETWORK;

    public LittleFrames() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> LittleFramesClient.load(FMLJavaModLoadingContext.get().getModEventBus()));
        LittleFramesRegistry.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        LittleFramesRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        LittleFramesRegistry.BLOCK_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerTabs);
    }

    private void init(FMLCommonSetupEvent event) {
        CONFIG = new LittleFramesConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
        NETWORK.registerType(CreativePictureFramePacket.class, CreativePictureFramePacket::new);
        if (ModList.get().isLoaded("littletiles")) {
            NETWORK.registerType(LittlePictureFramePacket.class, LittlePictureFramePacket::new);
            LittleStructureBuilder.register((LittleStructureBuilder.LittleStructureBuilderType)new LittleStructureBuilder.LittleStructureBuilderType(LittleStructureRegistry.register((String)"little_picture_frame", LittlePictureFrame.class, LittlePictureFrame::new, (LittleAttributeBuilder)new LittleAttributeBuilder().tickRendering().ticking()), "frame"));
            LittleTilesIntegration.init();
        }
    }

    private void registerTabs(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_256788_) {
            event.m_246326_((ItemLike)LittleFramesRegistry.CREATIVE_PICTURE_FRAME.get());
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation(MODID, "main"));
    }
}

