/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.display;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import me.srrapero720.watermedia.Util;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.video.VideoLANPlayer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.texture.TextureCache;

public class FrameVideoDisplay
extends FrameDisplay {
    private static final int ACCEPTABLE_SYNC_TIME = 1000;
    private static final List<FrameVideoDisplay> OPEN_DISPLAYS = new ArrayList<FrameVideoDisplay>();
    public volatile int width = 1;
    public volatile int height = 1;
    public VideoLANPlayer player;
    private final Vec3d pos;
    private volatile IntBuffer buffer;
    public int texture;
    private boolean stream = false;
    private volatile float lastSetVolume;
    private volatile boolean needsUpdate = false;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean first = true;
    private long lastCorrectedTime = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                if (!Minecraft.m_91087_().m_91104_()) continue;
                if (display.stream) {
                    if (!display.player.isPlaying()) continue;
                    display.player.setPauseMode(true);
                    continue;
                }
                if (display.player.getDuration() <= 0L || !display.player.isPlaying()) continue;
                display.player.setPauseMode(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                display.free();
            }
            OPEN_DISPLAYS.clear();
        }
    }

    public static FrameDisplay createVideoDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        if (WaterMediaAPI.isVLCReady()) {
            FrameVideoDisplay display = new FrameVideoDisplay(pos, url, volume, minDistance, maxDistance, loop);
            OPEN_DISPLAYS.add(display);
            return display;
        }
        TextureCache cache = new TextureCache(Util.ARCH.wrapped ? WaterMediaAPI.VLC_FAILED.image : WaterMediaAPI.VLC_FAILED_INSTALL.image);
        if (cache.ready()) {
            return cache.createDisplay(pos, null, volume, minDistance, maxDistance, loop, true);
        }
        return null;
    }

    public FrameVideoDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        this.pos = pos;
        this.texture = GlStateManager.m_84111_();
        this.player = new VideoLANPlayer(null, (mediaPlayer, nativeBuffers, bufferFormat) -> {
            this.lock.lock();
            try {
                this.buffer.put(nativeBuffers[0].asIntBuffer());
                this.buffer.rewind();
                this.needsUpdate = true;
            }
            finally {
                this.lock.unlock();
            }
        }, new BufferFormatCallback(){

            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                FrameVideoDisplay.this.lock.lock();
                try {
                    FrameVideoDisplay.this.width = sourceWidth;
                    FrameVideoDisplay.this.height = sourceHeight;
                    FrameVideoDisplay.this.first = true;
                    FrameVideoDisplay.this.buffer = MemoryTracker.m_182527_((int)(sourceWidth * sourceHeight * 4)).asIntBuffer();
                    FrameVideoDisplay.this.needsUpdate = true;
                }
                finally {
                    FrameVideoDisplay.this.lock.unlock();
                }
                return new BufferFormat("RGBA", sourceWidth, sourceHeight, new int[]{sourceWidth * 4}, new int[]{sourceHeight});
            }

            public void allocatedBuffers(ByteBuffer[] buffers) {
            }
        });
        float tempVolume = this.getVolume(volume, minDistance, maxDistance);
        this.player.setVolume((int)tempVolume);
        this.lastSetVolume = tempVolume;
        this.player.setRepeatMode(loop);
        this.player.start((CharSequence)url);
    }

    public int getVolume(float volume, float minDistance, float maxDistance) {
        if (this.player == null) {
            return 0;
        }
        float distance = (float)this.pos.distance(Minecraft.m_91087_().f_91074_.m_20318_(CreativeCoreClient.getFrameTime()));
        if (minDistance > maxDistance) {
            float temp = maxDistance;
            maxDistance = minDistance;
            minDistance = temp;
        }
        if (distance > minDistance) {
            volume = distance > maxDistance ? 0.0f : (volume *= 1.0f - (distance - minDistance) / (maxDistance - minDistance));
        }
        return (int)(volume * 100.0f);
    }

    @Override
    public void tick(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        if ((volume = (float)this.getVolume(volume, minDistance, maxDistance)) != this.lastSetVolume) {
            this.player.setVolume((int)volume);
            this.lastSetVolume = volume;
        }
        if (this.player.isValid()) {
            boolean realPlaying;
            boolean bl = realPlaying = playing && !Minecraft.m_91087_().m_91104_();
            if (this.player.getRepeatMode() != loop) {
                this.player.setRepeatMode(loop);
            }
            long tickTime = 50L;
            if (this.player.isStream()) {
                if (this.player.isPlaying() != realPlaying) {
                    this.player.setPauseMode(!realPlaying);
                }
            } else if (this.player.getDuration() > 0L) {
                if (this.player.isPlaying() != realPlaying) {
                    this.player.setPauseMode(!realPlaying);
                }
                if (this.player.isSeekable()) {
                    long time = (long)tick * tickTime + (realPlaying ? (long)(CreativeCoreClient.getFrameTime() * (float)tickTime) : 0L);
                    if (time > this.player.getTime() && loop) {
                        time %= this.player.getDuration();
                    }
                    if (Math.abs(time - this.player.getTime()) > 1000L && Math.abs(time - this.lastCorrectedTime) > 1000L) {
                        this.lastCorrectedTime = time;
                        this.player.seekTo(time);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.needsUpdate) {
                GlStateManager.m_84522_((int)3314, (int)0);
                GlStateManager.m_84522_((int)3316, (int)0);
                GlStateManager.m_84522_((int)3315, (int)0);
                RenderSystem.m_69396_((int)this.texture);
                if (this.first) {
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (IntBuffer)this.buffer);
                    this.first = false;
                } else {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)6408, (int)5121, (IntBuffer)this.buffer);
                }
                this.needsUpdate = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void free() {
        if (this.player != null) {
            VideoLANPlayer tempPlayer = this.player;
            tempPlayer.release();
        }
        if (this.texture != -1) {
            GlStateManager.m_84541_((int)this.texture);
            this.texture = -1;
        }
        this.player = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.free();
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            OPEN_DISPLAYS.remove(this);
        }
    }

    @Override
    public int texture() {
        return this.texture;
    }

    @Override
    public void pause(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.seekGameTicksTo(tick);
        this.player.pause();
    }

    @Override
    public void resume(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.seekGameTicksTo(tick);
        this.player.play();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

