/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.packet;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littleframes.common.structure.LittlePictureFrame;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.structure.LittleStructure;

public class LittlePictureFramePacket
extends CreativePacket {
    public StructureLocation location;
    public boolean playing;
    public int tick;

    public LittlePictureFramePacket() {
    }

    public LittlePictureFramePacket(StructureLocation location, boolean playing, int tick) {
        this.location = location;
        this.playing = playing;
        this.tick = tick;
    }

    public void executeClient(Player player) {
        try {
            LittleStructure structure = this.location.find((LevelAccessor)player.f_19853_);
            if (structure instanceof LittlePictureFrame) {
                LittlePictureFrame frame = (LittlePictureFrame)structure;
                frame.playing = this.playing;
                frame.tick = this.tick;
                if (frame.display != null) {
                    if (this.playing) {
                        frame.display.resume(frame.getURL(), frame.volume, frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
                    } else {
                        frame.display.pause(frame.getURL(), frame.volume, frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
                    }
                }
            }
        }
        catch (LittleActionException littleActionException) {
            // empty catch block
        }
    }

    public void executeServer(ServerPlayer player) {
    }
}

