/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.PushReaction;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.misc.CachedFunction;

public class CaveStartCalculator {
    private final BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
    private final CachedFunction<StateHolder<?, ?>, Boolean> transparentCache = new CachedFunction<StateHolder, Boolean>(state -> mapWriter.shouldOverlay((StateHolder<?, ?>)state));

    public CaveStartCalculator(MapWriter mapWriter) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCaving(double playerX, double playerY, double playerZ, Level world) {
        if (WorldMap.settings.autoCaveMode == 0) {
            return Integer.MAX_VALUE;
        }
        int worldBottomY = world.m_141937_();
        int worldTopY = world.m_151558_() - 1;
        int y = (int)playerY + 1;
        int defaultCaveStart = y + 3;
        int defaultResult = Integer.MAX_VALUE;
        if (y > worldTopY || y < worldBottomY) {
            return defaultResult;
        }
        int x = Mth.m_14107_((double)playerX);
        int z = Mth.m_14107_((double)playerZ);
        int roofRadius = WorldMap.settings.autoCaveMode < 0 ? 1 : WorldMap.settings.autoCaveMode - 1;
        int roofDiameter = 1 + roofRadius * 2;
        int startX = x - roofRadius;
        int startZ = z - roofRadius;
        boolean ignoringHeightmaps = WorldMap.settings.ignoreHeightmaps;
        int bottom = y;
        int top = Integer.MAX_VALUE;
        LevelChunk prevBChunk = null;
        int potentialResult = defaultCaveStart;
        for (int o = 0; o < roofDiameter; ++o) {
            block1: for (int p = 0; p < roofDiameter; ++p) {
                int currentX = startX + o;
                int currentZ = startZ + p;
                this.mutableBlockPos.m_122178_(currentX, y, currentZ);
                LevelChunk bchunk = world.m_6325_(currentX >> 4, currentZ >> 4);
                if (bchunk == null) {
                    return defaultResult;
                }
                int skyLight = world.m_45517_(LightLayer.SKY, (BlockPos)this.mutableBlockPos);
                if (!ignoringHeightmaps) {
                    if (skyLight >= 15) return defaultResult;
                    int insideX = currentX & 0xF;
                    int insideZ = currentZ & 0xF;
                    top = bchunk.m_5885_(Heightmap.Types.WORLD_SURFACE, insideX, insideZ);
                } else if (bchunk != prevBChunk) {
                    LevelChunkSection[] sections = bchunk.m_7103_();
                    if (sections.length == 0) {
                        return defaultResult;
                    }
                    int playerSection = y - worldBottomY >> 4;
                    boolean foundSomething = false;
                    for (int i = playerSection; i < sections.length; ++i) {
                        LevelChunkSection searchedSection = sections[i];
                        if (searchedSection.m_188008_()) continue;
                        if (!foundSomething) {
                            bottom = Math.max(bottom, worldBottomY + (i << 4));
                            foundSomething = true;
                        }
                        top = worldBottomY + (i << 4) + 15;
                    }
                    if (!foundSomething) {
                        return defaultResult;
                    }
                    prevBChunk = bchunk;
                }
                if (top < worldBottomY) {
                    return defaultResult;
                }
                if (top > worldTopY) {
                    top = worldTopY;
                }
                for (int i = bottom; i <= top; ++i) {
                    this.mutableBlockPos.m_142448_(i);
                    BlockState state = world.m_8055_((BlockPos)this.mutableBlockPos);
                    if (state.m_60795_() || state.m_60767_().m_76338_() == PushReaction.DESTROY || state.m_60734_() instanceof LiquidBlock || state.m_204336_(BlockTags.f_13035_) || this.transparentCache.apply((StateHolder<?, ?>)state).booleanValue() || state.m_60734_() == Blocks.f_50375_) continue;
                    if (o != p || o != roofRadius) continue block1;
                    potentialResult = Math.min(i, defaultCaveStart);
                    continue block1;
                }
                return defaultResult;
            }
        }
        return potentialResult;
    }
}

