/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.misc.Misc;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;

public class TrackedPlayerIconPrerenderer {
    private ImprovedFramebuffer renderFramebuffer;
    private XaeroIconAtlas lastAtlas;
    private PoseStack matrixStack = new PoseStack();
    private final PlayerTrackerIconRenderer renderer = new PlayerTrackerIconRenderer();

    public void prerender(XaeroIcon icon, Player player, int iconWidth, ResourceLocation skinTextureLocation, PlayerTrackerMapElement<?> mapElement) {
        if (this.renderFramebuffer == null) {
            this.renderFramebuffer = new ImprovedFramebuffer(icon.getTextureAtlas().getWidth(), icon.getTextureAtlas().getWidth(), false);
            GlStateManager.m_84541_((int)this.renderFramebuffer.m_83975_());
        }
        this.renderFramebuffer.m_83947_(false);
        GlStateManager.m_84430_((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)iconWidth, (int)iconWidth);
        this.renderFramebuffer.setFramebufferTexture(icon.getTextureAtlas().getTextureId());
        this.renderFramebuffer.m_83949_();
        if (this.lastAtlas != icon.getTextureAtlas()) {
            RenderSystem.m_69424_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.m_69421_((int)16384, (boolean)Minecraft.f_91002_);
            this.lastAtlas = icon.getTextureAtlas();
        }
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)iconWidth, (float)iconWidth, 0.0f, -1.0f, 1000.0f);
        RenderSystem.m_252934_((Matrix4f)ortho);
        PoseStack shaderMatrixStack = RenderSystem.m_157191_();
        shaderMatrixStack.m_85836_();
        shaderMatrixStack.m_166856_();
        RenderSystem.m_157182_();
        PoseStack matrixStack = this.matrixStack;
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(iconWidth / 2), (float)(iconWidth / 2), 0.0f);
        matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)-5, (int)-5, (int)5, (int)5, (int)-1);
        this.renderer.renderIcon(matrixStack, player, skinTextureLocation);
        matrixStack.m_85849_();
        Minecraft mc = Minecraft.m_91087_();
        Misc.minecraftOrtho(mc, false);
        shaderMatrixStack.m_85849_();
        RenderSystem.m_157182_();
        this.renderFramebuffer.m_83970_();
        this.renderFramebuffer.bindDefaultFramebuffer(mc);
        GlStateManager.m_84430_((int)0, (int)0, (int)mc.m_91268_().m_85441_(), (int)mc.m_91268_().m_85442_());
    }
}

