/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiChildControl {
    public final GuiControl control;
    public Rect rect;

    public GuiChildControl(GuiControl control) {
        this.control = control;
        this.rect = new Rect(0.0, 0.0, 0.0, 0.0);
    }

    public int getX() {
        return (int)this.rect.minX;
    }

    public void setX(int x) {
        int width = this.getWidth();
        this.rect.minX = x;
        this.rect.maxX = x + width;
    }

    public int getY() {
        return (int)this.rect.minY;
    }

    public void setY(int y) {
        int height = this.getHeight();
        this.rect.minY = y;
        this.rect.maxY = y + height;
    }

    public int getWidth() {
        return (int)this.rect.getWidth();
    }

    public int getHeight() {
        return (int)this.rect.getHeight();
    }

    public int getContentWidth() {
        return (int)this.rect.getWidth() - this.control.getContentOffset() * 2;
    }

    public int getContentHeight() {
        return (int)this.rect.getHeight() - this.control.getContentOffset() * 2;
    }

    public void setWidth(int width, int availableWidth) {
        int max;
        int min = this.getMinWidth(availableWidth);
        if (min != -1) {
            width = Math.max(width, min);
        }
        if ((max = this.getMaxWidth(availableWidth)) != -1) {
            width = Math.min(width, max);
        }
        this.rect.maxX = this.rect.minX + (double)width;
    }

    public void setHeight(int height, int availableHeight) {
        int max;
        int min = this.getMinHeight(availableHeight);
        if (min != -1) {
            height = Math.max(height, min);
        }
        if ((max = this.getMaxHeight(availableHeight)) != -1) {
            height = Math.min(height, max);
        }
        this.rect.maxY = this.rect.minY + (double)height;
    }

    public int addWidth(int additional, int availableWidth) {
        int before = this.getWidth();
        this.setWidth(this.getWidth() + additional, availableWidth);
        return this.getWidth() - before;
    }

    public int addHeight(int additional, int availableHeight) {
        int before = this.getHeight();
        this.setHeight(this.getHeight() + additional, availableHeight);
        return this.getHeight() - before;
    }

    public boolean isMaxWidth(int availableWidth) {
        if (this.getMaxWidth(availableWidth) != -1) {
            return this.getWidth() >= this.getMaxWidth(availableWidth);
        }
        return false;
    }

    public boolean isMaxHeight(int availableHeight) {
        if (this.getMaxHeight(availableHeight) != -1) {
            return this.getHeight() >= this.getMaxHeight(availableHeight);
        }
        return false;
    }

    public int getMinWidth(int availableWidth) {
        int min = this.control.getMinWidth(availableWidth);
        if (min != -1) {
            return min + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getMaxWidth(int availableWidth) {
        int max = this.control.getMaxWidth(availableWidth);
        if (max != -1) {
            return max + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getPreferredWidth(int availableWidth) {
        return this.control.getPreferredWidth(availableWidth) + this.control.getContentOffset() * 2;
    }

    public int getMinHeight(int availableHeight) {
        int min = this.control.getMinHeight(this.getContentWidth(), availableHeight);
        if (min != -1) {
            return min + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getMaxHeight(int availableHeight) {
        int max = this.control.getMaxHeight(this.getContentWidth(), availableHeight);
        if (max != -1) {
            return max + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getPreferredHeight(int availableHeight) {
        return this.control.getPreferredHeight(this.getContentWidth(), availableHeight) + this.control.getContentOffset() * 2;
    }

    public void flowX() {
        int width = this.getContentWidth();
        this.control.flowX(width, this.control.preferredWidth(width));
    }

    public void flowY() {
        int width = this.getContentWidth();
        int height = this.getContentHeight();
        this.control.flowY(width, height, this.control.preferredHeight(width, height));
    }

    public int getBottom() {
        return (int)this.rect.maxY;
    }

    public boolean isMouseOver(double x, double y) {
        return this.rect.inside(x, y);
    }

    public boolean isExpandableX() {
        return this.control.isExpandableX();
    }

    public boolean isExpandableY() {
        return this.control.isExpandableY();
    }
}

