/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.inventory;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.CreativeCoreGuiRegistry;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlotBase;
import team.creative.creativecore.common.gui.controls.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiSlot
extends GuiSlotBase {
    public final Slot slot;
    public int draggedIndex = -1;

    public GuiSlot(Container container, int index) {
        this("", container, index);
    }

    public GuiSlot(String name, Container container, int index) {
        this(name + index, new Slot(container, index, 0, 0));
    }

    public GuiSlot(Slot slot) {
        this("" + slot.m_150661_(), slot);
    }

    public GuiSlot(String name, Slot slot) {
        super(name);
        this.slot = slot;
    }

    @Override
    public ItemStack getStack() {
        return this.slot.m_7993_();
    }

    @Override
    protected ItemStack getStackToRender() {
        if (this.draggedIndex != -1) {
            ItemStack stack = this.itemManager().getHand().m_41777_();
            int toAdd = Math.min(this.itemManager().additionalDragCount(this.draggedIndex), this.slot.m_5866_(stack) - this.slot.m_7993_().m_41613_());
            stack.m_41764_(toAdd + this.slot.m_7993_().m_41613_());
            return stack;
        }
        return this.getStack();
    }

    public GuiManagerItem itemManager() {
        return this.getLayer().itemManager();
    }

    public IGuiInventory inventory() {
        IGuiParent parent = this.getParent();
        while (!(parent instanceof IGuiInventory)) {
            if (parent instanceof GuiParent) {
                parent = ((GuiParent)parent).getParent();
                continue;
            }
            throw new RuntimeException("Slot needs inventory parent");
        }
        return (IGuiInventory)((Object)parent);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92094_.m_90832_(keyCode, scanCode)) {
            CreativeCoreGuiRegistry.DROP.sendAndExecute(this, ByteTag.m_128273_((boolean)Screen.m_96637_()));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        if (!Screen.m_96638_()) {
            return false;
        }
        if (delta > 0.0) {
            CreativeCoreGuiRegistry.INSERT.sendAndExecute(this, IntTag.m_128679_((int)((int)delta)));
        } else {
            CreativeCoreGuiRegistry.EXTRACT.sendAndExecute(this, IntTag.m_128679_((int)((int)delta)));
        }
        return true;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (this.itemManager().isDragged()) {
            return true;
        }
        if (Screen.m_96638_()) {
            if (this.slot.m_8010_(this.getPlayer())) {
                CreativeCoreGuiRegistry.INSERT.sendAndExecute(this, IntTag.m_128679_((int)this.slot.m_6641_()));
            }
            return true;
        }
        ItemStack hand = this.itemManager().getHand();
        if (!hand.m_41619_() && button < 2) {
            int stackSize = GuiManagerItem.freeSpace(this.slot, hand);
            if (stackSize > 0) {
                this.itemManager().startDrag(this, button == 1, stackSize);
            }
            if (stackSize != -1) {
                return true;
            }
        }
        if (button == 2) {
            CreativeCoreGuiRegistry.DUPLICATE.sendAndExecute(this, EndTag.f_128534_);
        } else if (this.slot.m_8010_(this.getPlayer()) && (hand.m_41619_() || this.slot.m_5857_(hand))) {
            CreativeCoreGuiRegistry.SWAP.sendAndExecute(this, ByteTag.m_128273_((button == 1 ? 1 : 0) != 0));
        }
        return true;
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        if (this.draggedIndex == -1 && this.itemManager().isDragged() && rect.inside(x + rect.minX, y + rect.minY)) {
            this.itemManager().addToDrag(this);
        }
    }

    public void changed() {
        this.inventory().setChanged(this.slot.m_150661_());
        if (this.draggedIndex != -1) {
            this.itemManager().modifyDrag(this);
        }
    }

    public ItemStack insert(ItemStack stack) {
        boolean canStack = AbstractContainerMenu.m_38899_((Slot)this.slot, (ItemStack)stack, (boolean)true);
        int availableStackSize = this.slot.m_5866_(stack);
        if (canStack && this.slot.m_5857_(stack)) {
            int additionalStackSize;
            int neededStackSize = stack.m_41613_();
            if (this.slot.m_6657_()) {
                availableStackSize -= this.slot.m_7993_().m_41613_();
            }
            if ((additionalStackSize = Math.min(availableStackSize, neededStackSize)) > 0) {
                ItemStack inSlot = stack.m_41777_();
                inSlot.m_41764_(additionalStackSize);
                if (this.slot.m_6657_()) {
                    inSlot.m_41769_(this.slot.m_7993_().m_41613_());
                }
                this.slot.m_5852_(inSlot);
                stack.m_41774_(additionalStackSize);
                this.changed();
            }
        }
        return stack;
    }
}

