/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextBuilder;

public class GuiProgressbar
extends GuiControl {
    public double pos;
    public double max;
    public boolean showToolTip = true;

    public GuiProgressbar(String name, double pos, double max) {
        super(name);
        this.pos = pos;
        this.max = max;
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public List<Component> getTooltip() {
        if (this.showToolTip) {
            return new TextBuilder().number(this.pos, true).text("/").number(this.max, true).text(" (").number(this.pos / this.max * 100.0, true).text("%)").build();
        }
        return super.getTooltip();
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.PROGRESSBAR;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        double percent = this.pos / this.max;
        this.renderProgress(pose, control, rect, percent);
        GuiRenderHelper.drawStringCentered(pose, (int)Math.round(percent * 100.0) + "%", (float)rect.getWidth(), (float)rect.getHeight(), this.getStyle().fontColor.toInt(), true);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderProgress(PoseStack pose, GuiChildControl control, Rect rect, double percent) {
        this.getStyle().clickable.render(pose, 0.0, 0.0, (int)(rect.getWidth() * percent), rect.getHeight());
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }
}

