/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;

public class AABBVoxelShape
extends SliceShape {
    public AABB bb;

    public static AABBVoxelShape create(AABB bb) {
        AABBVoxelShape shape = CreativeHackery.allocateInstance(AABBVoxelShape.class);
        shape.bb = bb;
        return shape;
    }

    protected AABBVoxelShape() {
        super(null, null, 0);
    }

    public boolean contains(Vec3d vec) {
        if (vec.x > this.bb.f_82288_ && vec.x < this.bb.f_82291_) {
            if (vec.y > this.bb.f_82289_ && vec.y < this.bb.f_82292_) {
                return vec.z > this.bb.f_82290_ && vec.z < this.bb.f_82293_;
            }
            return false;
        }
        return false;
    }

    protected double get(Facing facing) {
        switch (facing) {
            case EAST: {
                return this.bb.f_82291_;
            }
            case WEST: {
                return this.bb.f_82288_;
            }
            case UP: {
                return this.bb.f_82292_;
            }
            case DOWN: {
                return this.bb.f_82289_;
            }
            case SOUTH: {
                return this.bb.f_82293_;
            }
            case NORTH: {
                return this.bb.f_82290_;
            }
        }
        return 0.0;
    }

    public Vec3d getCorner(BoxCorner corner) {
        return new Vec3d(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public double getCornerValue(BoxCorner corner, Axis axis) {
        return this.get(corner.getFacing(axis));
    }

    public double getCornerX(BoxCorner corner) {
        return this.get(corner.x);
    }

    public double getCornerY(BoxCorner corner) {
        return this.get(corner.y);
    }

    public double getCornerZ(BoxCorner corner) {
        return this.get(corner.z);
    }

    public Vec3d getSizeVec() {
        return new Vec3d(this.bb.f_82291_ - this.bb.f_82288_, this.bb.f_82292_ - this.bb.f_82289_, this.bb.f_82293_ - this.bb.f_82290_);
    }

    public double getVolume() {
        return (this.bb.f_82291_ - this.bb.f_82288_) * (this.bb.f_82292_ - this.bb.f_82289_) * (this.bb.f_82293_ - this.bb.f_82290_);
    }

    public double getIntersectionVolume(AABB other) {
        double d0 = Math.max(this.bb.f_82288_, other.f_82288_);
        double d1 = Math.max(this.bb.f_82289_, other.f_82289_);
        double d2 = Math.max(this.bb.f_82290_, other.f_82290_);
        double d3 = Math.min(this.bb.f_82291_, other.f_82291_);
        double d4 = Math.min(this.bb.f_82292_, other.f_82292_);
        double d5 = Math.min(this.bb.f_82293_, other.f_82293_);
        if (d0 < d3 && d1 < d4 && d2 < d5) {
            return Math.abs((d3 - d0) * (d4 - d1) * (d5 - d2));
        }
        return 0.0;
    }

    public double getSize(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.bb.f_82291_ - this.bb.f_82288_;
            }
            case Y: {
                return this.bb.f_82292_ - this.bb.f_82289_;
            }
            case Z: {
                return this.bb.f_82293_ - this.bb.f_82290_;
            }
        }
        return 0.0;
    }

    public double getMin(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.bb.f_82288_;
            }
            case Y: {
                return this.bb.f_82289_;
            }
            case Z: {
                return this.bb.f_82290_;
            }
        }
        return 0.0;
    }

    public double getMax(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.bb.f_82291_;
            }
            case Y: {
                return this.bb.f_82292_;
            }
            case Z: {
                return this.bb.f_82293_;
            }
        }
        return 0.0;
    }

    public double getMin(Axis axis) {
        switch (axis) {
            case X: {
                return this.bb.f_82288_;
            }
            case Y: {
                return this.bb.f_82289_;
            }
            case Z: {
                return this.bb.f_82290_;
            }
        }
        return 0.0;
    }

    public double getMax(Axis axis) {
        switch (axis) {
            case X: {
                return this.bb.f_82291_;
            }
            case Y: {
                return this.bb.f_82292_;
            }
            case Z: {
                return this.bb.f_82293_;
            }
        }
        return 0.0;
    }

    public static double get(AABB bb, Facing facing) {
        switch (facing) {
            case EAST: {
                return bb.f_82291_;
            }
            case WEST: {
                return bb.f_82288_;
            }
            case UP: {
                return bb.f_82292_;
            }
            case DOWN: {
                return bb.f_82289_;
            }
            case SOUTH: {
                return bb.f_82293_;
            }
            case NORTH: {
                return bb.f_82290_;
            }
        }
        return 0.0;
    }

    public static double getMin(AABB bb, Axis axis) {
        switch (axis) {
            case X: {
                return bb.f_82288_;
            }
            case Y: {
                return bb.f_82289_;
            }
            case Z: {
                return bb.f_82290_;
            }
        }
        return 0.0;
    }

    public static double getMax(AABB bb, Axis axis) {
        switch (axis) {
            case X: {
                return bb.f_82291_;
            }
            case Y: {
                return bb.f_82292_;
            }
            case Z: {
                return bb.f_82293_;
            }
        }
        return 0.0;
    }

    public static double getMin(AABB bb, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return bb.f_82288_;
            }
            case Y: {
                return bb.f_82289_;
            }
            case Z: {
                return bb.f_82290_;
            }
        }
        return 0.0;
    }

    public static double getMax(AABB bb, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return bb.f_82291_;
            }
            case Y: {
                return bb.f_82292_;
            }
            case Z: {
                return bb.f_82293_;
            }
        }
        return 0.0;
    }

    public static Vec3d getCorner(AABB bb, BoxCorner corner) {
        return new Vec3d(AABBVoxelShape.getCornerX(bb, corner), AABBVoxelShape.getCornerY(bb, corner), AABBVoxelShape.getCornerZ(bb, corner));
    }

    public static double getCornerValue(AABB bb, BoxCorner corner, Axis axis) {
        return AABBVoxelShape.get(bb, corner.getFacing(axis));
    }

    public static double getCornerX(AABB bb, BoxCorner corner) {
        return AABBVoxelShape.get(bb, corner.x);
    }

    public static double getCornerY(AABB bb, BoxCorner corner) {
        return AABBVoxelShape.get(bb, corner.y);
    }

    public static double getCornerZ(AABB bb, BoxCorner corner) {
        return AABBVoxelShape.get(bb, corner.z);
    }

    protected DoubleList m_7700_(Direction.Axis axis) {
        throw new UnsupportedOperationException();
    }

    public double m_83288_(Direction.Axis axis) {
        return this.bb.m_82340_(axis);
    }

    public double m_83297_(Direction.Axis axis) {
        return this.bb.m_82374_(axis);
    }

    public AABB m_83215_() {
        return this.bb;
    }

    protected double m_83256_(Direction.Axis axis, int p_83258_) {
        return this.m_7700_(axis).getDouble(p_83258_);
    }

    public boolean m_83281_() {
        return false;
    }

    public VoxelShape m_83216_(double x, double y, double z) {
        return AABBVoxelShape.create(this.bb.m_82386_(x, y, z));
    }

    public VoxelShape m_83296_() {
        return this;
    }

    public void m_83224_(Shapes.DoubleLineConsumer consumer) {
        throw new UnsupportedOperationException();
    }

    public void m_83286_(Shapes.DoubleLineConsumer consumer) {
        consumer.m_83161_(this.bb.f_82288_, this.bb.f_82289_, this.bb.f_82290_, this.bb.f_82291_, this.bb.f_82292_, this.bb.f_82293_);
    }

    public List<AABB> m_83299_() {
        return new SingletonList<AABB>(this.bb);
    }

    public double m_166078_(Direction.Axis axis, double one, double two) {
        return this.m_83288_(axis);
    }

    public double m_83290_(Direction.Axis axis, double one, double two) {
        return this.m_83297_(axis);
    }

    protected int m_6595_(Direction.Axis axis, double value) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public BlockHitResult m_83220_(Vec3 pos, Vec3 look, BlockPos block) {
        return AABB.m_82342_(new SingletonList<AABB>(this.bb), (Vec3)pos, (Vec3)look, (BlockPos)block);
    }

    public Optional<Vec3> m_166067_(Vec3 vec) {
        Vec3 avec3 = null;
        double d0 = Mth.m_14008_((double)vec.m_7096_(), (double)this.bb.f_82288_, (double)this.bb.f_82291_);
        double d1 = Mth.m_14008_((double)vec.m_7098_(), (double)this.bb.f_82289_, (double)this.bb.f_82292_);
        double d2 = Mth.m_14008_((double)vec.m_7094_(), (double)this.bb.f_82290_, (double)this.bb.f_82293_);
        if (avec3 == null || vec.m_82531_(d0, d1, d2) < vec.m_82557_(avec3)) {
            avec3 = new Vec3(d0, d1, d2);
        }
        return Optional.of(avec3);
    }

    public VoxelShape m_83263_(Direction p_83264_) {
        return this;
    }

    public double collideStepUp(AABB other, AABB otherY, double offset) {
        double newOffset = this.m_83259_(Direction.Axis.Y, otherY, offset);
        if (offset > 0.0 ? newOffset < offset : newOffset > offset) {
            return newOffset / 2.0;
        }
        return newOffset;
    }

    public double m_83259_(Direction.Axis axis, AABB bb, double value) {
        throw new UnsupportedOperationException();
    }

    protected double m_83245_(AxisCycle cycle, AABB bb, double distance) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "AABBVoxelShape[" + this.bb + "]";
    }
}

