/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import org.joml.Vector2d;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AABBVoxelShape;
import team.creative.creativecore.common.util.math.box.BoxUtils;
import team.creative.creativecore.common.util.math.collision.IntersectionHelper;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;

public class OBBVoxelShape
extends AABBVoxelShape {
    public IVecOrigin origin;

    public static OBBVoxelShape create(AABB bb, IVecOrigin origin) {
        OBBVoxelShape shape = CreativeHackery.allocateInstance(OBBVoxelShape.class);
        shape.bb = bb;
        shape.origin = origin;
        return shape;
    }

    private OBBVoxelShape() {
    }

    private static int getCornerOffset(double value, double min, double max) {
        if (value <= min) {
            return -1;
        }
        if (value >= max) {
            return 1;
        }
        return 0;
    }

    public double calculateDistanceRotated(AABB other, Axis axis, double offset) {
        boolean positive = offset > 0.0;
        Facing facing = Facing.get(axis, !positive);
        double closestValue = OBBVoxelShape.get(other, facing.opposite());
        Axis one = axis.one();
        Axis two = axis.two();
        double minOne = OBBVoxelShape.getMin(other, one);
        double minTwo = OBBVoxelShape.getMin(other, two);
        double maxOne = OBBVoxelShape.getMax(other, one);
        double maxTwo = OBBVoxelShape.getMax(other, two);
        Vec3d[] corners = BoxUtils.getOuterCorner(facing, this.origin, this.bb, minOne, minTwo, maxOne, maxTwo);
        Vec3d outerCorner = corners[0];
        double outerCornerOne = outerCorner.get(one);
        double outerCornerTwo = outerCorner.get(two);
        double outerCornerAxis = outerCorner.get(axis);
        int outerCornerOffsetOne = OBBVoxelShape.getCornerOffset(outerCornerOne, minOne, maxOne);
        int outerCornerOffsetTwo = OBBVoxelShape.getCornerOffset(outerCornerTwo, minTwo, maxTwo);
        if (outerCornerOffsetOne == 0 && outerCornerOffsetTwo == 0) {
            if (positive) {
                return outerCorner.get(axis) - closestValue;
            }
            return closestValue - outerCorner.get(axis);
        }
        Vector2d[] directions = new Vector2d[3];
        double minDistance = Double.MAX_VALUE;
        Vec2d[] vectors = new Vec2d[]{new Vec2d(minOne - outerCornerOne, minTwo - outerCornerTwo), new Vec2d(maxOne - outerCornerOne, minTwo - outerCornerTwo), new Vec2d(maxOne - outerCornerOne, maxTwo - outerCornerTwo), new Vec2d(minOne - outerCornerOne, maxTwo - outerCornerTwo)};
        Vec2d[] vectorsRelative = new Vec2d[]{new Vec2d(), new Vec2d(), new Vec2d(), new Vec2d()};
        directions[0] = new Vector2d(corners[1].get(one) - outerCornerOne, corners[1].get(two) - outerCornerTwo);
        directions[1] = new Vector2d(corners[2].get(one) - outerCornerOne, corners[2].get(two) - outerCornerTwo);
        directions[2] = new Vector2d(corners[3].get(one) - outerCornerOne, corners[3].get(two) - outerCornerTwo);
        block0: for (int i = 0; i < 3; ++i) {
            int j;
            int indexFirst = i;
            int indexSecond = i == 2 ? 0 : i + 1;
            Vector2d first = directions[indexFirst];
            Vector2d second = directions[indexSecond];
            if (first.x == 0.0 || second.y == 0.0) {
                int temp = indexFirst;
                indexFirst = indexSecond;
                indexSecond = temp;
                first = directions[indexFirst];
                second = directions[indexSecond];
            }
            double firstAxisValue = corners[indexFirst + 1].get(axis);
            double secondAxisValue = corners[indexSecond + 1].get(axis);
            boolean allInside = true;
            for (j = 0; j < 4; ++j) {
                double s;
                Vec2d vector = vectors[j];
                double t = (vector.x * second.y - vector.y * second.x) / (first.x * second.y - first.y * second.x);
                if (Double.isNaN(t) || Double.isInfinite(t) || Double.isNaN(s = (vector.y - t * first.y) / second.y) || Double.isInfinite(s)) continue block0;
                if (t <= 0.0 || t >= 1.0 || s <= 0.0 || s >= 1.0) {
                    allInside = false;
                }
                vectorsRelative[j].set(t, s);
            }
            if (allInside) {
                for (j = 0; j < vectorsRelative.length; ++j) {
                    double distance = OBBVoxelShape.calculateDistanceFromPlane(positive, closestValue, vectorsRelative[j], firstAxisValue, secondAxisValue, outerCornerAxis);
                    minDistance = Math.min(distance, minDistance);
                }
                continue;
            }
            List<Vec2d> points = IntersectionHelper.cutMinMax(0.0, 0.0, 1.0, 1.0, vectorsRelative);
            for (int j2 = 0; j2 < points.size(); ++j2) {
                double distance = OBBVoxelShape.calculateDistanceFromPlane(positive, closestValue, points.get(j2), firstAxisValue, secondAxisValue, outerCornerAxis);
                minDistance = Math.min(distance, minDistance);
            }
        }
        if (minDistance == Double.MAX_VALUE) {
            return -1.0;
        }
        return minDistance;
    }

    public static double calculateDistanceFromPlane(boolean positive, double closestValue, Vec2d vec, double firstAxisValue, double secondAxisValue, double outerCornerAxis) {
        double valueAxis = outerCornerAxis + (firstAxisValue - outerCornerAxis) * vec.x + (secondAxisValue - outerCornerAxis) * vec.y;
        return positive ? valueAxis - closestValue : closestValue - valueAxis;
    }

    public static boolean intersectsWithAxis(Direction.Axis axis, AABB bb, AABB bb2) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (bb.f_82289_ < bb2.f_82292_ && bb.f_82292_ > bb2.f_82289_ && bb.f_82290_ < bb2.f_82293_ && bb.f_82293_ > bb2.f_82290_) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (bb.f_82288_ < bb2.f_82291_ && bb.f_82291_ > bb2.f_82288_ && bb.f_82290_ < bb2.f_82293_ && bb.f_82293_ > bb2.f_82290_) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> bb.f_82288_ < bb2.f_82291_ && bb.f_82291_ > bb2.f_82288_ && bb.f_82289_ < bb2.f_82292_ && bb.f_82292_ > bb2.f_82289_;
        };
    }

    @Override
    public double m_83259_(Direction.Axis axis, AABB other, double offset) {
        if (offset == 0.0) {
            return offset;
        }
        if (Math.abs(offset) < 1.0E-7) {
            return 0.0;
        }
        if (!OBBVoxelShape.intersectsWithAxis(axis, this.bb, other)) {
            return offset;
        }
        double distance = this.calculateDistanceRotated(other, Axis.get(axis), offset);
        if (distance < 0.0 && !Maths.equals(distance, 0.0)) {
            return offset;
        }
        if (offset > 0.0) {
            if (distance < offset) {
                return distance;
            }
            return offset;
        }
        if (offset < 0.0) {
            if (-distance > offset) {
                return -distance;
            }
            return offset;
        }
        return offset;
    }
}

