/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import java.util.function.Supplier;
import mod.casinocraft.blockentity.BlockEntityMachine;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.network.MessageScoreClient;
import mod.casinocraft.system.CasinoPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageScoreServer {
    static int points;
    static String names;
    static BlockPos pos;

    public MessageScoreServer(String scoreName, int scorePoints, BlockPos pos) {
        points = scorePoints;
        names = scoreName;
        MessageScoreServer.pos = pos;
    }

    public static void encode(MessageScoreServer msg, FriendlyByteBuf buf) {
        buf.writeInt(points);
        buf.m_130072_(names, 24);
        buf.m_130064_(pos);
    }

    public static MessageScoreServer decode(FriendlyByteBuf buf) {
        int _points = buf.readInt();
        String _names = buf.m_130136_(24);
        BlockPos _pos = buf.m_130135_();
        return new MessageScoreServer(_names, _points, _pos);
    }

    public static class Handler {
        public static void handle(MessageScoreServer message, Supplier<NetworkEvent.Context> context) {
            BlockEntityMachine te = (BlockEntityMachine)context.get().getSender().m_9236_().m_46745_(pos).m_7702_(pos);
            context.get().enqueueWork(() -> {
                ((LogicModule)te.logic).addScore(names, points);
                ((LogicModule)te.logic).resetPlayers();
            });
            CasinoPacketHandler.sendToChunk(new MessageScoreClient(names, points, pos), context.get().getSender().f_19853_.m_46745_(pos));
            context.get().setPacketHandled(true);
        }
    }
}

