/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.mino;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.mino.LogicMinoBlue;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ScreenMinoBlue
extends ScreenCasino {
    public ScreenMinoBlue(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
    }

    public LogicMinoBlue logic() {
        return (LogicMinoBlue)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return "memory";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_MID_LEFT, ButtonMap.CONTINUE, () -> this.isActivePlayer() && this.logic().turnstate == 3, () -> this.action(-1));
        this.buttonSet.addButton(ButtonMap.POS_MID_RIGHT, ButtonMap.GIVEUP, () -> this.isActivePlayer() && this.logic().turnstate == 3, () -> this.action(-2));
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
        if (this.logic().turnstate == 2) {
            for (int y = 0; y < 9; ++y) {
                for (int x = 0; x < 17; ++x) {
                    if (!this.mouseRect(-76 + x * 24, 20 + y * 24, 24, 24, mouseX, mouseY)) continue;
                    this.action(y * 17 + x);
                }
            }
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        this.drawValueLeft(matrix, "POINTS", this.logic().scorePoint);
        this.drawValueRight(matrix, "LIVES", this.logic().scoreLives);
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_MINOS);
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 17; ++x) {
                if (this.logic().grid[x][y] == -1) continue;
                if (this.logic().positionA.matches(x, y)) {
                    this.drawMino(matrix, -76 + 24 * x, 20 + 24 * y, this.logic().grid[x][y] + 1, this.logic().grid[x][y] + 1);
                    continue;
                }
                if (this.logic().positionB.matches(x, y)) {
                    this.drawMino(matrix, -76 + 24 * x, 20 + 24 * y, this.logic().grid[x][y] + 1, this.logic().grid[x][y] + 1);
                    continue;
                }
                this.drawMino(matrix, -76 + 24 * x, 20 + 24 * y, 0, 0);
            }
        }
    }
}

