/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib;

import bagu_chan.bagus_lib.BagusConfigs;
import bagu_chan.bagus_lib.message.CameraMessage;
import bagu_chan.bagus_lib.message.UpdateDataMessage;
import bagu_chan.bagus_lib.register.ModEntities;
import bagu_chan.bagus_lib.register.ModSensors;
import bagu_chan.bagus_lib.util.WebHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bagus_lib")
public class BagusLib {
    public static final String MODID = "bagus_lib";
    public static final String NETWORK_PROTOCOL = "2";
    public static List<String> PATREONS = new ArrayList<String>();
    public static final Logger LOGGER = LogManager.getLogger((String)"bagus_lib");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("bagus_lib", "net")).networkProtocolVersion(() -> "2").clientAcceptedVersions("2"::equals).serverAcceptedVersions("2"::equals).simpleChannel();

    public BagusLib() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModEntities.ENTITIES_REGISTRY.register(modEventBus);
        ModSensors.SENSOR_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BagusConfigs.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BagusConfigs.CLIENT_SPEC);
        this.setupMessages();
    }

    private void setupMessages() {
        CHANNEL.messageBuilder(CameraMessage.class, 0).encoder(CameraMessage::writeToPacket).decoder(CameraMessage::readFromPacket).consumerMainThread(CameraMessage::handle).add();
        CHANNEL.messageBuilder(UpdateDataMessage.class, 1).encoder(UpdateDataMessage::writeToPacket).decoder(UpdateDataMessage::readFromPacket).consumerMainThread(UpdateDataMessage::handle).add();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BufferedReader urlContents = WebHelper.getURLContents("https://raw.githubusercontent.com/baguchan/BagusLib/master/src/main/resources/assets/bagus_lib/patreon.txt", "assets/bagus_lib/patreon.txt");
        if (urlContents != null) {
            try {
                String line;
                while ((line = urlContents.readLine()) != null) {
                    PATREONS.add(line);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load perks");
            }
        } else {
            LOGGER.warn("Failed to load perks");
        }
    }

    public static boolean isFunker(Player player) {
        return PATREONS.contains(player.m_7755_().getString());
    }
}

