/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.layer;

import bagu_chan.bagus_lib.client.layer.IArmor;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Quaternionf;

public class CustomArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private final HumanoidModel defaultBipedModel;
    private final HumanoidModel innerModel;
    private RenderLayerParent<T, M> renderer;
    private final TextureAtlas armorTrimAtlas;

    public CustomArmorLayer(RenderLayerParent<T, M> render, EntityRendererProvider.Context context) {
        super(render);
        this.defaultBipedModel = new HumanoidModel(context.m_174023_(ModelLayers.f_171261_));
        this.innerModel = new HumanoidModel(context.m_174023_(ModelLayers.f_171208_));
        this.renderer = render;
        this.armorTrimAtlas = context.m_266367_().m_119428_(Sheets.f_265912_);
    }

    public CustomArmorLayer(RenderLayerParent<T, M> render, EntityModelSet modelSet, ModelManager modelManager) {
        super(render);
        this.defaultBipedModel = new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171261_));
        this.innerModel = new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171208_));
        this.renderer = render;
        this.armorTrimAtlas = modelManager.m_119428_(Sheets.f_265912_);
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, CustomArmorLayer.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float f2;
        float f1;
        float f;
        int i;
        int clampedLight;
        boolean flag1;
        boolean notAVanillaModel;
        HumanoidModel<?> a;
        ArmorItem armoritem;
        matrixStackIn.m_85836_();
        ItemStack headItem = entity.m_6844_(EquipmentSlot.HEAD);
        if (headItem.m_41720_() instanceof ArmorItem) {
            armoritem = (ArmorItem)headItem.m_41720_();
            if (headItem.canEquip(EquipmentSlot.HEAD, (Entity)entity)) {
                a = this.defaultBipedModel;
                notAVanillaModel = (a = this.getArmorModelHook(entity, headItem, EquipmentSlot.HEAD, (HumanoidModel)a)) != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.HEAD);
                flag1 = headItem.m_41790_();
                clampedLight = packedLightIn;
                if (armoritem instanceof DyeableLeatherItem) {
                    i = ((DyeableLeatherItem)armoritem).m_41121_(headItem);
                    f = (float)(i >> 16 & 0xFF) / 255.0f;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderHelmet(headItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, CustomArmorLayer.getArmorResource((Entity)entity, headItem, EquipmentSlot.HEAD, null), notAVanillaModel);
                    this.renderHelmet(headItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, headItem, EquipmentSlot.HEAD, "overlay"), notAVanillaModel);
                } else {
                    this.renderHelmet(headItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, headItem, EquipmentSlot.HEAD, null), notAVanillaModel);
                }
            }
        } else {
            ((IArmor)this.renderer.m_7200_()).headPartArmors().forEach(part -> {
                ((IArmor)this.renderer.m_7200_()).translateToHead((ModelPart)part, matrixStackIn);
                matrixStackIn.m_252781_(new Quaternionf().rotateX((float)Math.PI));
                matrixStackIn.m_252781_(new Quaternionf().rotateY((float)Math.PI));
                Minecraft.m_91087_().m_91291_().m_269128_(headItem, ItemDisplayContext.FIXED, packedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, entity.f_19853_, 0);
            });
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        ItemStack chestItem = entity.m_6844_(EquipmentSlot.CHEST);
        if (chestItem.m_41720_() instanceof ArmorItem && (armoritem = (ArmorItem)chestItem.m_41720_()).m_40402_() == EquipmentSlot.CHEST) {
            a = this.defaultBipedModel;
            notAVanillaModel = (a = this.getArmorModelHook(entity, chestItem, EquipmentSlot.CHEST, (HumanoidModel)a)) != this.defaultBipedModel;
            this.setModelSlotVisible((HumanoidModel)a, EquipmentSlot.CHEST);
            flag1 = chestItem.m_41790_();
            clampedLight = packedLightIn;
            if (armoritem instanceof DyeableLeatherItem) {
                i = ((DyeableLeatherItem)armoritem).m_41121_(chestItem);
                f = (float)(i >> 16 & 0xFF) / 255.0f;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                f2 = (float)(i & 0xFF) / 255.0f;
                this.renderChestplate(chestItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, CustomArmorLayer.getArmorResource((Entity)entity, chestItem, EquipmentSlot.CHEST, null), notAVanillaModel);
                this.renderChestplate(chestItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, chestItem, EquipmentSlot.CHEST, "overlay"), notAVanillaModel);
            } else {
                this.renderChestplate(chestItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, chestItem, EquipmentSlot.CHEST, null), notAVanillaModel);
            }
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        ItemStack legItem = entity.m_6844_(EquipmentSlot.LEGS);
        if (legItem.m_41720_() instanceof ArmorItem && (armoritem = (ArmorItem)legItem.m_41720_()).m_40402_() == EquipmentSlot.LEGS) {
            a = this.innerModel;
            notAVanillaModel = (a = this.getArmorModelHook(entity, legItem, EquipmentSlot.LEGS, (HumanoidModel)a)) != this.defaultBipedModel;
            this.setModelSlotVisible((HumanoidModel)a, EquipmentSlot.LEGS);
            flag1 = legItem.m_41790_();
            clampedLight = packedLightIn;
            if (armoritem instanceof DyeableLeatherItem) {
                i = ((DyeableLeatherItem)armoritem).m_41121_(legItem);
                f = (float)(i >> 16 & 0xFF) / 255.0f;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                f2 = (float)(i & 0xFF) / 255.0f;
                this.renderLeg(legItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, CustomArmorLayer.getArmorResource((Entity)entity, legItem, EquipmentSlot.LEGS, null), notAVanillaModel);
                this.renderLeg(legItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, legItem, EquipmentSlot.LEGS, "overlay"), notAVanillaModel);
            } else {
                this.renderLeg(legItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, legItem, EquipmentSlot.LEGS, null), notAVanillaModel);
            }
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        ItemStack feetItem = entity.m_6844_(EquipmentSlot.FEET);
        if (feetItem.m_41720_() instanceof ArmorItem && (armoritem = (ArmorItem)feetItem.m_41720_()).m_40402_() == EquipmentSlot.FEET) {
            a = this.defaultBipedModel;
            notAVanillaModel = (a = this.getArmorModelHook(entity, feetItem, EquipmentSlot.FEET, (HumanoidModel)a)) != this.defaultBipedModel;
            this.setModelSlotVisible(a, EquipmentSlot.FEET);
            flag1 = feetItem.m_41790_();
            clampedLight = packedLightIn;
            if (armoritem instanceof DyeableLeatherItem) {
                i = ((DyeableLeatherItem)armoritem).m_41121_(feetItem);
                f = (float)(i >> 16 & 0xFF) / 255.0f;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                f2 = (float)(i & 0xFF) / 255.0f;
                this.renderBoot(feetItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, CustomArmorLayer.getArmorResource((Entity)entity, feetItem, EquipmentSlot.FEET, null), notAVanillaModel);
                this.renderBoot(feetItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, feetItem, EquipmentSlot.FEET, "overlay"), notAVanillaModel);
            } else {
                this.renderBoot(feetItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, feetItem, EquipmentSlot.FEET, null), notAVanillaModel);
            }
        }
        matrixStackIn.m_85849_();
    }

    private static boolean usesInnerModel(EquipmentSlot p_117129_) {
        return p_117129_ == EquipmentSlot.LEGS;
    }

    private HumanoidModel getArmorModel(EquipmentSlot p_117079_) {
        return CustomArmorLayer.usesInnerModel(p_117079_) ? this.innerModel : this.defaultBipedModel;
    }

    private void renderTrim(ArmorMaterial p_267946_, PoseStack p_268019_, MultiBufferSource p_268023_, int p_268190_, ArmorTrim p_267984_, boolean p_267965_, HumanoidModel p_267949_, boolean p_268259_, float p_268337_, float p_268095_, float p_268305_) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(p_268259_ ? p_267984_.m_267774_(p_267946_) : p_267984_.m_267606_(p_267946_));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(ItemRenderer.m_115222_((MultiBufferSource)p_268023_, (RenderType)Sheets.m_266442_(), (boolean)true, (boolean)p_267965_));
        p_267949_.m_7695_(p_268019_, vertexconsumer, p_268190_, OverlayTexture.f_118083_, p_268337_, p_268095_, p_268305_, 1.0f);
    }

    private void renderTrim(ItemStack item, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, EquipmentSlot equipmentSlot, HumanoidModel modelIn) {
        Item item2 = item.m_41720_();
        if (item2 instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item2;
            ArmorTrim.m_266285_((RegistryAccess)entity.f_19853_.m_9598_(), (ItemStack)item).ifPresent(p_267897_ -> this.renderTrim(armorItem.m_40401_(), matrixStackIn, bufferIn, packedLightIn, (ArmorTrim)p_267897_, glintIn, modelIn, CustomArmorLayer.usesInnerModel(equipmentSlot), 1.0f, 1.0f, 1.0f));
        }
    }

    private void renderLeg(ItemStack legItem, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        this.renderer.m_7200_().m_102624_((EntityModel)modelIn);
        modelIn.f_102810_.f_104203_ = 0.0f;
        modelIn.f_102810_.f_104204_ = 0.0f;
        modelIn.f_102810_.f_104205_ = 0.0f;
        modelIn.f_102810_.f_104200_ = 0.0f;
        modelIn.f_102810_.f_104201_ = 0.0f;
        modelIn.f_102810_.f_104202_ = 0.0f;
        modelIn.f_102813_.f_104200_ = 0.0f;
        modelIn.f_102813_.f_104203_ = 0.0f;
        modelIn.f_102813_.f_104204_ = 0.0f;
        modelIn.f_102813_.f_104205_ = 0.0f;
        modelIn.f_102814_.f_104200_ = 0.0f;
        modelIn.f_102814_.f_104203_ = 0.0f;
        modelIn.f_102814_.f_104204_ = 0.0f;
        modelIn.f_102814_.f_104205_ = 0.0f;
        modelIn.f_102814_.f_104201_ = 0.0f;
        modelIn.f_102813_.f_104201_ = 0.0f;
        modelIn.f_102814_.f_104202_ = 0.0f;
        modelIn.f_102813_.f_104202_ = 0.0f;
        modelIn.f_102810_.f_104207_ = false;
        modelIn.f_102813_.f_104207_ = true;
        modelIn.f_102814_.f_104207_ = false;
        ((IArmor)this.renderer.m_7200_()).rightLegPartArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToLeg((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(legItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.LEGS, modelIn);
            matrixStackIn.m_85849_();
        });
        modelIn.f_102813_.f_104207_ = false;
        modelIn.f_102814_.f_104207_ = true;
        ((IArmor)this.renderer.m_7200_()).leftLegPartArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToLeg((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(legItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.LEGS, modelIn);
            matrixStackIn.m_85849_();
        });
        modelIn.f_102810_.f_104207_ = true;
        modelIn.f_102813_.f_104207_ = false;
        modelIn.f_102814_.f_104207_ = false;
        ((IArmor)this.renderer.m_7200_()).bodyPartArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToChest((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(legItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.LEGS, modelIn);
            matrixStackIn.m_85849_();
        });
        modelIn.f_102813_.f_104207_ = true;
        modelIn.f_102814_.f_104207_ = true;
    }

    private void renderBoot(ItemStack feetItem, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        this.renderer.m_7200_().m_102624_((EntityModel)modelIn);
        modelIn.f_102813_.f_104200_ = 0.0f;
        modelIn.f_102813_.f_104203_ = 0.0f;
        modelIn.f_102813_.f_104204_ = 0.0f;
        modelIn.f_102813_.f_104205_ = 0.0f;
        modelIn.f_102814_.f_104200_ = 0.0f;
        modelIn.f_102814_.f_104203_ = 0.0f;
        modelIn.f_102814_.f_104204_ = 0.0f;
        modelIn.f_102814_.f_104205_ = 0.0f;
        modelIn.f_102814_.f_104201_ = 0.0f;
        modelIn.f_102813_.f_104201_ = 0.0f;
        modelIn.f_102814_.f_104202_ = 0.0f;
        modelIn.f_102813_.f_104202_ = 0.0f;
        modelIn.f_102813_.f_104207_ = true;
        modelIn.f_102814_.f_104207_ = false;
        ((IArmor)this.renderer.m_7200_()).rightLegPartArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToLeg((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(feetItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.FEET, modelIn);
            matrixStackIn.m_85849_();
        });
        modelIn.f_102813_.f_104207_ = false;
        modelIn.f_102814_.f_104207_ = true;
        ((IArmor)this.renderer.m_7200_()).leftLegPartArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToLeg((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(feetItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.FEET, modelIn);
            matrixStackIn.m_85849_();
        });
        modelIn.f_102813_.f_104207_ = true;
        modelIn.f_102814_.f_104207_ = true;
    }

    private void renderChestplate(ItemStack chestItem, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        this.renderer.m_7200_().m_102624_((EntityModel)modelIn);
        modelIn.f_102810_.f_104203_ = 0.0f;
        modelIn.f_102810_.f_104204_ = 0.0f;
        modelIn.f_102810_.f_104205_ = 0.0f;
        modelIn.f_102810_.f_104200_ = 0.0f;
        modelIn.f_102810_.f_104201_ = 0.0f;
        modelIn.f_102810_.f_104202_ = 0.0f;
        modelIn.f_102811_.f_104200_ = 0.0f;
        modelIn.f_102811_.f_104201_ = 0.0f;
        modelIn.f_102811_.f_104202_ = 0.0f;
        modelIn.f_102811_.f_104203_ = 0.0f;
        modelIn.f_102811_.f_104204_ = 0.0f;
        modelIn.f_102811_.f_104205_ = 0.0f;
        modelIn.f_102812_.f_104200_ = 0.0f;
        modelIn.f_102812_.f_104201_ = 0.0f;
        modelIn.f_102812_.f_104202_ = 0.0f;
        modelIn.f_102812_.f_104203_ = 0.0f;
        modelIn.f_102812_.f_104204_ = 0.0f;
        modelIn.f_102812_.f_104205_ = 0.0f;
        modelIn.f_102812_.f_104201_ = 0.0f;
        modelIn.f_102811_.f_104201_ = 0.0f;
        modelIn.f_102812_.f_104202_ = 0.0f;
        modelIn.f_102811_.f_104202_ = 0.0f;
        modelIn.f_102810_.f_104207_ = false;
        modelIn.f_102811_.f_104207_ = true;
        modelIn.f_102812_.f_104207_ = false;
        ((IArmor)this.renderer.m_7200_()).rightHandArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToChestPat((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(chestItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.CHEST, modelIn);
            matrixStackIn.m_85849_();
        });
        modelIn.f_102811_.f_104207_ = false;
        modelIn.f_102812_.f_104207_ = true;
        ((IArmor)this.renderer.m_7200_()).leftHandArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToChestPat((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(chestItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.CHEST, modelIn);
            matrixStackIn.m_85849_();
        });
        modelIn.f_102810_.f_104207_ = true;
        modelIn.f_102811_.f_104207_ = false;
        modelIn.f_102812_.f_104207_ = false;
        ((IArmor)this.renderer.m_7200_()).bodyPartArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToChest((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(chestItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.CHEST, modelIn);
            matrixStackIn.m_85849_();
        });
        modelIn.f_102811_.f_104207_ = true;
        modelIn.f_102812_.f_104207_ = true;
    }

    private void renderHelmet(ItemStack headItem, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        this.renderer.m_7200_().m_102624_((EntityModel)modelIn);
        modelIn.f_102808_.f_104203_ = 0.0f;
        modelIn.f_102808_.f_104204_ = 0.0f;
        modelIn.f_102808_.f_104205_ = 0.0f;
        modelIn.f_102809_.f_104203_ = 0.0f;
        modelIn.f_102809_.f_104204_ = 0.0f;
        modelIn.f_102809_.f_104205_ = 0.0f;
        modelIn.f_102808_.f_104200_ = 0.0f;
        modelIn.f_102808_.f_104201_ = 0.0f;
        modelIn.f_102808_.f_104202_ = 0.0f;
        modelIn.f_102809_.f_104200_ = 0.0f;
        modelIn.f_102809_.f_104201_ = 0.0f;
        modelIn.f_102809_.f_104202_ = 0.0f;
        ((IArmor)this.renderer.m_7200_()).headPartArmors().forEach(part -> {
            matrixStackIn.m_85836_();
            ((IArmor)this.renderer.m_7200_()).translateToHead((ModelPart)part, matrixStackIn);
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderTrim(headItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.HEAD, modelIn);
            matrixStackIn.m_85849_();
        });
    }

    protected void setModelSlotVisible(HumanoidModel p_188359_1_, EquipmentSlot slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.f_102808_.f_104207_ = true;
                p_188359_1_.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                p_188359_1_.f_102810_.f_104207_ = true;
                p_188359_1_.f_102811_.f_104207_ = true;
                p_188359_1_.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                p_188359_1_.f_102810_.f_104207_ = true;
                p_188359_1_.f_102813_.f_104207_ = true;
                p_188359_1_.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                p_188359_1_.f_102813_.f_104207_ = true;
                p_188359_1_.f_102814_.f_104207_ = true;
            }
        }
    }

    protected void setModelVisible(HumanoidModel model) {
        model.m_8009_(false);
    }

    protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        Model basicModel = ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
        return basicModel instanceof HumanoidModel ? (HumanoidModel)basicModel : model;
    }
}

