/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.IFellableBlock;
import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.TreeData;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopDataImpl;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.chop.ChopTreeResult;
import ht.treechop.common.chop.FellTreeResult;
import ht.treechop.common.chop.LazyTreeData;
import ht.treechop.common.config.ChopCounting;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.BlockUtil;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.common.util.TreeDataImpl;
import ht.treechop.server.Server;
import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.GraphUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ChopUtil {
    public static boolean isBlockALog(Level level, BlockPos pos) {
        return ChopUtil.isBlockALog(level, pos, level.m_8055_(pos));
    }

    public static boolean isBlockALog(Level level, BlockPos pos, BlockState blockState) {
        return ChopUtil.isBlockChoppable((BlockGetter)level, pos, blockState);
    }

    public static boolean isBlockChoppable(Level level, BlockPos pos) {
        return ChopUtil.isBlockChoppable((BlockGetter)level, pos, level.m_8055_(pos));
    }

    public static boolean isBlockChoppable(BlockGetter level, BlockPos pos, BlockState blockState) {
        return ClassUtil.getChoppableBlock(level, pos, blockState) != null;
    }

    public static boolean isBlockLeaves(Level level, BlockPos pos) {
        return ChopUtil.isBlockLeaves(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(BlockState blockState) {
        if (ConfigHandler.COMMON.leavesBlocks.get().contains(blockState.m_60734_())) {
            return (Boolean)ConfigHandler.COMMON.ignorePersistentLeaves.get() == false || !blockState.m_61138_((Property)LeavesBlock.f_54419_) || (Boolean)blockState.m_61143_((Property)LeavesBlock.f_54419_) == false;
        }
        return false;
    }

    public static boolean enoughChopsToFell(int chops, double support) {
        return ChopCounting.calculate((int)support) <= chops;
    }

    public static int numChopsToFell(Level level, Stream<BlockPos> logs) {
        int support = Math.max(logs.map(pos -> ChopUtil.getSupportFactor(level, pos)).reduce(Double::sum).orElse(1.0).intValue(), 1);
        return ChopCounting.calculate(support);
    }

    public static Optional<Double> getSupportFactor(Level level, Stream<BlockPos> blocks) {
        return blocks.map(pos -> ChopUtil.getSupportFactor(level, pos)).reduce(Double::sum);
    }

    public static double getSupportFactor(Level level, BlockPos pos) {
        return ChopUtil.getSupportFactor(level, pos, level.m_8055_(pos));
    }

    private static double getSupportFactor(Level level, BlockPos pos, BlockState state) {
        double d;
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof IFellableBlock) {
            IFellableBlock block2 = (IFellableBlock)block;
            d = block2.getSupportFactor((BlockGetter)level, pos, state);
        } else {
            d = 1.0;
        }
        return d;
    }

    public static ChopResult getChopResult(Level level, BlockPos origin, ChopSettings chopSettings, int numChops, boolean fellIfPossible) {
        return fellIfPossible ? ChopUtil.getChopResult(level, origin, chopSettings, numChops) : ChopUtil.tryToChopWithoutFelling(level, origin, numChops);
    }

    private static ChopResult getChopResult(Level level, BlockPos origin, ChopSettings chopSettings, int numChops) {
        DirectedGraph<BlockPos> world = BlockNeighbors.HORIZONTAL_AND_ABOVE::asStream;
        Set<BlockPos> base = ChopUtil.getTreeBase(level, origin);
        int baseChops = base.stream().map(pos -> ChopUtil.getNumChops(level, pos)).reduce(Integer::sum).orElse(0);
        Predicate<BlockPos> logFilter = pos -> ChopUtil.isBlockALog(level, pos);
        TreeData tree = ChopUtil.getTree(level, origin, base, world, logFilter, pos -> ChopUtil.isBlockLeaves(level, pos), (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get(), baseChops);
        if (tree.isAProperTree(chopSettings.getTreesMustHaveLeaves())) {
            return ChopUtil.getChopResult(level, origin, tree, base, world, logFilter, numChops);
        }
        return ChopResult.IGNORED;
    }

    public static TreeData getTree(Level level, BlockPos blockPos, int maxNumTreeBlocks) {
        Set<BlockPos> base = ChopUtil.getTreeBase(level, blockPos);
        int baseChops = base.stream().map(pos -> ChopUtil.getNumChops(level, pos)).reduce(Integer::sum).orElse(0);
        return ChopUtil.getTree(level, blockPos, base, BlockNeighbors.HORIZONTAL_AND_ABOVE::asStream, pos -> ChopUtil.isBlockALog(level, pos), pos -> ChopUtil.isBlockLeaves(level, pos), maxNumTreeBlocks, baseChops);
    }

    public static TreeData getTree(Level level, BlockPos origin, Set<BlockPos> base, DirectedGraph<BlockPos> world, Predicate<BlockPos> logFilter, Predicate<BlockPos> leavesFilter, int maxNumTreeBlocks, int numChops) {
        if (base.isEmpty()) {
            return TreeDataImpl.empty(level);
        }
        LazyTreeData treeData = new LazyTreeData(level, base, world, logFilter, leavesFilter, maxNumTreeBlocks, numChops);
        return TreeChop.platform.detectTreeEvent(level, null, origin, level.m_8055_(origin), treeData);
    }

    @NotNull
    private static Set<BlockPos> getTreeBase(Level level, BlockPos blockPos) {
        HashSet<BlockPos> base = new HashSet<BlockPos>();
        if (ChopUtil.isBlockChoppable(level, blockPos)) {
            DirectedGraph<BlockPos> adjacentWorld = BlockNeighbors.ADJACENTS_AND_DIAGONALS::asStream;
            base.add(blockPos);
            GraphUtil.flood(GraphUtil.filterNeighbors(adjacentWorld, pos -> ChopUtil.getNumChops(level, pos) > 0), blockPos, Vec3i::m_123342_).fill().forEach(base::add);
        }
        return base;
    }

    private static ChopResult getChopResult(Level level, BlockPos origin, TreeData tree, Set<BlockPos> base, DirectedGraph<BlockPos> world, Predicate<BlockPos> logFilter, int numChops) {
        if (tree.streamLogs().findFirst().isEmpty()) {
            return ChopResult.IGNORED;
        }
        if (tree.readyToFell(tree.getChops() + numChops)) {
            return new FellTreeResult(level, tree);
        }
        return new ChopTreeResult(level, ChopUtil.spillChops(level, origin, base, world, logFilter, numChops));
    }

    private static List<Chop> spillChops(Level level, BlockPos origin, Set<BlockPos> base, DirectedGraph<BlockPos> treeGraph, Predicate<BlockPos> logFilter, int numChops) {
        Stack<Chop> chops = new Stack<Chop>();
        AtomicInteger chopsLeft = new AtomicInteger(numChops);
        if (chopsLeft.get() > 0) {
            GraphUtil.flood(GraphUtil.filter(treeGraph, logFilter), base, a -> ChopUtil.blockDistance(origin, a) * 32 + RandomUtils.nextInt((int)0, (int)32)).fill().takeWhile(pos -> {
                chopsLeft.set(ChopUtil.gatherChopAndGetNumChopsRemaining(level, pos, chopsLeft.get(), chops));
                return chopsLeft.get() > 0;
            }).count();
        }
        return chops;
    }

    private static int gatherChopAndGetNumChopsRemaining(Level level, BlockPos targetPos, int numChops, List<Chop> choppedBlocks) {
        BlockState blockStateBeforeChopping = level.m_8055_(targetPos);
        if (!(blockStateBeforeChopping.m_60734_() instanceof IChoppableBlock) && ChopUtil.isBlockSurrounded(level, targetPos)) {
            return numChops;
        }
        int adjustedNumChops = ChopUtil.adjustNumChops(level, targetPos, blockStateBeforeChopping, numChops, false);
        if (adjustedNumChops > 0) {
            choppedBlocks.add(new Chop(targetPos, adjustedNumChops));
        }
        return numChops - adjustedNumChops;
    }

    private static boolean isBlockSurrounded(Level level, BlockPos pos) {
        return Stream.of(pos.m_122024_(), pos.m_122012_(), pos.m_122029_(), pos.m_122019_()).allMatch(neighborPos -> ChopUtil.isBlockALog(level, neighborPos));
    }

    public static int adjustNumChops(Level level, BlockPos blockPos, BlockState blockState, int numChops, boolean destructive) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((BlockGetter)level, blockPos, blockState);
        if (choppableBlock != null) {
            if (destructive) {
                return numChops;
            }
            int currentNumChops = choppableBlock.getNumChops((BlockGetter)level, blockPos, blockState);
            int maxNondestructiveChops = choppableBlock.getMaxNumChops((BlockGetter)level, blockPos, blockState) - currentNumChops;
            return Math.min(maxNondestructiveChops, numChops);
        }
        return 0;
    }

    public static int getMaxNumChops(Level level, BlockPos blockPos, BlockState blockState) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((BlockGetter)level, blockPos, blockState);
        return choppableBlock != null ? choppableBlock.getMaxNumChops((BlockGetter)level, blockPos, blockState) : 0;
    }

    public static int getNumChops(Level level, BlockPos pos) {
        return ChopUtil.getNumChops(level, pos, level.m_8055_(pos));
    }

    public static int getNumChops(Level level, BlockPos pos, BlockState blockState) {
        int n;
        Block block = blockState.m_60734_();
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            n = choppableBlock.getNumChops((BlockGetter)level, pos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    public static int getNumChops(Level level, Set<BlockPos> positions) {
        return positions.stream().map(pos -> Pair.of((Object)pos, (Object)level.m_8055_(pos))).map(posAndblockState -> {
            Integer n;
            Block patt10545$temp = ((BlockState)posAndblockState.getRight()).m_60734_();
            if (patt10545$temp instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)patt10545$temp;
                n = choppableBlock.getNumChops((BlockGetter)level, (BlockPos)posAndblockState.getLeft(), (BlockState)posAndblockState.getRight());
            } else {
                n = 0;
            }
            return n;
        }).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(Level level, BlockPos blockPos, int numChops) {
        return ChopUtil.isBlockChoppable(level, blockPos) ? new ChopTreeResult(level, Collections.singletonList(new Chop(blockPos, numChops))) : ChopResult.IGNORED;
    }

    public static int blockDistance(BlockPos a, BlockPos b) {
        return a.m_123333_((Vec3i)b);
    }

    public static int horizontalBlockDistance(BlockPos a, BlockPos b) {
        return new Vec3i(a.m_123341_(), 0, a.m_123343_()).m_123333_(new Vec3i(b.m_123341_(), 0, b.m_123343_()));
    }

    public static boolean canChopWithTool(Player player, Level level, BlockPos pos) {
        return ChopUtil.canChopWithTool(player, player.m_21205_(), level, pos, level.m_8055_(pos));
    }

    public static boolean canChopWithTool(Player player, ItemStack tool, Level level, BlockPos pos, BlockState blockState) {
        return !((Boolean)ConfigHandler.COMMON.mustUseCorrectToolForDrops.get() != false && blockState.m_60834_() && !tool.m_41735_(blockState) || (Boolean)ConfigHandler.COMMON.mustUseFastBreakingTool.get() != false && !(tool.m_41691_(blockState) > 1.0f) || !ConfigHandler.canChopWithTool(player, tool, level, pos, blockState));
    }

    public static int getNumChopsByTool(ItemStack tool, BlockState blockState) {
        IChoppingItem choppingItem = ClassUtil.getChoppingItem(tool.m_41720_());
        if (choppingItem != null) {
            return choppingItem.getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(Player player, ChopSettings chopSettings) {
        if (((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && (player != null && !player.m_7500_() || chopSettings.getChopInCreativeMode())) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
        }
        return false;
    }

    public static boolean playerWantsToFell(Player player, ChopSettings chopSettings) {
        return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((Entity)player);
    }

    public static boolean chop(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ItemStack tool, Object trigger) {
        ChopSettings chopSettings = Server.instance().getPlayerChopData((Player)agent).getSettings();
        if (!(ChopUtil.isBlockChoppable((BlockGetter)level, pos, blockState) && ChopUtil.playerWantsToChop((Player)agent, chopSettings) && ChopUtil.canChopWithTool((Player)agent, tool, (Level)level, pos, blockState))) {
            return false;
        }
        ChopDataImpl chopData = new ChopDataImpl(ChopUtil.getNumChopsByTool(tool, blockState), ChopUtil.playerWantsToFell((Player)agent, chopSettings));
        boolean doChop = TreeChop.platform.startChopEvent(agent, level, pos, blockState, chopData, trigger);
        if (!doChop) {
            return false;
        }
        ChopResult chopResult = ChopUtil.getChopResult((Level)level, pos, chopSettings, chopData.getNumChops(), chopData.getFelling());
        if (chopResult != ChopResult.IGNORED) {
            chopResult.apply(pos, agent, tool, (Boolean)ConfigHandler.COMMON.breakLeaves.get());
            TreeChop.platform.finishChopEvent(agent, level, pos, blockState, chopData, chopResult);
            tool.m_41686_((Level)level, blockState, pos, (Player)agent);
            boolean felled = chopResult instanceof FellTreeResult;
            return !felled;
        }
        return false;
    }

    public static BlockState getStrippedState(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return ChopUtil.getStrippedState(level, pos, state, state);
    }

    public static BlockState getStrippedState(BlockAndTintGetter level, BlockPos pos, BlockState state, BlockState fallback) {
        BlockState strippedState;
        BlockState blockState = strippedState = AxeAccessor.isStripped(state.m_60734_()) ? state : AxeAccessor.getStripped(state);
        if (strippedState == null && (strippedState = TreeChop.platform.getStrippedState(level, pos, state)) == null) {
            IStrippableBlock strippableBlock = ClassUtil.getStrippableBlock(state.m_60734_());
            if (strippableBlock != null) {
                return strippableBlock.getStrippedState((BlockGetter)level, pos, state);
            }
            strippedState = ConfigHandler.inferredStrippedStates.get().get(state.m_60734_());
        }
        return strippedState != null ? BlockUtil.copyStateProperties(strippedState, state) : fallback;
    }

    public static Block getLogBlock(Level level, BlockPos pos) {
        return ChopUtil.getLogBlock(level, pos, level.m_8055_(pos));
    }

    public static Block getLogBlock(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            return entity.getOriginalState().m_60734_();
        }
        return state.m_60734_();
    }
}

